from openeo.rest.datacube import DataCube
from openeo.processes import date_shift


def cropsar_pixel_inputs(vito_connection, bbox, start, end, gan_window_half: int = 90) -> DataCube:

    start_shifted = date_shift(start, -gan_window_half, "day")
    end_shifted = date_shift(end, gan_window_half, "day")

    S2bands = vito_connection.load_collection(
        'TERRASCOPE_S2_TOC_V2',
        bands=['B04', 'B08', 'SCL'],
        spatial_extent=bbox,
        temporal_extent=[start_shifted, end_shifted]
    )
    S2bands = S2bands.process("mask_scl_dilation", data=S2bands, scl_band_name="SCL")

    B4band = S2bands.band('B04')
    B8band = S2bands.band('B08')
    S2ndvi = (B8band - B4band) / (B8band + B4band)
    S2ndvi = S2ndvi.add_dimension("bands", "S2ndvi", type="bands")

    S1bands = vito_connection.load_collection(
        'TERRASCOPE_S1_GAMMA0_V1',
        bands=['VH', 'VV'],
        spatial_extent=bbox,
        temporal_extent=[start_shifted, end_shifted]
    )
    S1bands = S1bands.resample_cube_spatial(S2ndvi)
    merged_cube = S2ndvi
    merged_cube = merged_cube.merge_cubes(S1bands)

    return merged_cube