import pandas as pd
import numpy as np

from openeo.rest.conversions import timeseries_json_to_pandas
from openeo_udf.api.udf_data import UdfData
from openeo_udf.api.structured_data import StructuredData
#import sys
#sys.path.append(r'/data/users/Public/bontek/Nextland/Anomaly_detection/cropsar-1.4.7-py3-none-any.whl') #TODO TO remove
from cropsar.preprocessing.retrieve_timeseries_openeo import run_cropsar_dataframes

def NtempDF(Td):
    # CONSTANTS
    c1 = 21.77
    HaP = 52750
    Rg = 8.3144
    DeltaS = 704.98
    HdP = 211000

    # CALCULATION
    pTd_numerator = np.exp(c1 - (HaP / (Rg * Td)))
    pTd_denominator = 1 + np.exp(((DeltaS * Td) - HdP) / (Rg * Td))
    pTd = pTd_numerator / pTd_denominator

    # RESULTS
    return pTd

def NcoFE(CO2conc, Td):
    #CO2conc= 405
    # CONSTANTS
    O2conc = 20.9
    CO2concref = 281
    Rg = 8.31
    Ea1 = 59400
    A1 = 2.419 * (10 ** 13)
    Ea2 = 109600
    A2 = 1.976 * (10 ** 22)
    E0 = 13913.5
    A0 = 8240
    Et = -42896.9
    At = 7.87 * (10 ** -5)

    # CALCULATION
    nptd = Td.to_numpy()

    T1arrix = np.where(nptd >= 288.13)
    T2arrix = np.where(nptd < 288)

    if len(nptd.shape) == 1:
        lines = len(nptd)
        samples = 0
        Km = np.zeros((lines), 'float')
    else:
        samples = len(nptd[0])
        lines = len(nptd)
        Km = np.zeros((lines, samples), 'float')

    Km[T1arrix] = A1 * np.exp(-Ea1 / (Rg * nptd[T1arrix]))
    Km[T2arrix] = A2 * np.exp(-Ea2 / (Rg * nptd[T2arrix]))

    K0 = A0 * np.exp(-E0 / (Rg * nptd))
    t = At * np.exp(-Et / (Rg * nptd))

    Nco2FE_numerator1 = CO2conc - (O2conc / (2 * t))
    Nco2FE_numerator2 = (Km * (1 + (O2conc / K0))) + CO2concref
    Nco2FE_denominator1 = CO2concref - (O2conc / (2 * t))
    Nco2FE_denominator2 = (Km * (1 + (O2conc / K0)) + CO2conc)

    Nco2FE = (Nco2FE_numerator1 / Nco2FE_denominator1) * (Nco2FE_numerator2 / Nco2FE_denominator2)

    # RESULTS
    return Nco2FE


def GDMP_Eff(T12, T24, CO2conc, RUE):
    # CONSTANTS
    ClimaticEff = 0.48
    # CALCULATION
    pTdval = NtempDF(T12)
    NcoFEval = NcoFE(CO2conc, T12)
    GDMPeffall = ClimaticEff * RUE * NcoFEval * pTdval
    # RESULTS
    return GDMPeffall

'''def GDMPtoDMP(GDMP,DMPfrac=0.5):
    # CONSTANTS
    DMP = GDMP * DMPfrac
    return DMP
'''


def get_cropsar_TS(ts_df):

    index_fAPAR = 2
    df_S2 = ts_df.iloc[: , [index_fAPAR]].copy().sort_index().T
    #df_S2.index = pd.to_datetime(df_S2.index).date
    #index_VHVV = [0,1]
    df_VHVV = ts_df.iloc[:, [0,1]].copy().sort_index().T
    #df_VHVV.index = pd.to_datetime(df_VHVV.index).date
    df_VH = ts_df.iloc[:, [0]].copy().sort_index().T
    df_VV = ts_df.iloc[:, [1]].copy().sort_index().T

    #cropsar_df = df_S2
    cropsar_df, cropsar_df_q10, cropsar_df_q90 = run_cropsar_dataframes(df_S2, df_VHVV, None)
    #cropsar_df, cropsar_df_q10, cropsar_df_q90 = run_cropsar_dataframes(df_S2, df_VH, df_VV)

    return cropsar_df


def udf_biomass(udf_data:UdfData):
    #Constants (Roel Van Hoolst)
    f_CO2conc = 405
    f_RUE = 2.54
    unit = 1
    GDMPorDMP = 'DMP'
    f_DMPfraction = 0.5
    scaling_meteo = 0.01
    scaling_solar_rad = 0.00001 # need to convert solar radiation to GJ/ha

    user_context = udf_data.user_context
    time_range = user_context.get('date')

    ts_dict = udf_data.get_structured_data_list()[0].data
    ts_dict2 = udf_data.get_structured_data_list()[0].description
    if not ts_dict: #workaround of ts_dict is empty
        return
    ts_df = timeseries_json_to_pandas(ts_dict, auto_collapse=False)
    ts_df.index = pd.to_datetime(ts_df.index).date

    #Collect cropsar data
    ts_df_cropsar = get_cropsar_TS(ts_df)

    ts_df = timeseries_json_to_pandas(ts_dict)
    ts_df.index = pd.to_datetime(ts_df.index).date

    ## need to set the input ts on the same axis length as cropsar (daily scale)
    date_range = pd.date_range(ts_df_cropsar.index[0], ts_df_cropsar.index[-1]).date
    ts_df = ts_df.reindex(date_range)

    ts_df['cropsar'] = ts_df_cropsar

    #Biomass calculations
    ts_df = ts_df.assign(tmin_k=lambda x: (x[8]*scaling_meteo ))
    ts_df = ts_df.assign(tmax_k=lambda x: (x[6]*scaling_meteo))
    ts_df = ts_df.assign(t12_k=lambda x: ((0.25 * x['tmin_k']) + (0.75 * x['tmax_k'])))
    ts_df = ts_df.assign(t24_k=lambda x: (0.50 * (x['tmin_k'] + x['tmax_k'])))
    ts_df = ts_df.assign(rad_u=lambda x: ((x[5]* scaling_solar_rad)))
    ts_df = ts_df.assign(DMPeffall=lambda x: GDMP_Eff(x['t12_k'],x['t24_k'],f_CO2conc,f_RUE))
    ts_df = ts_df.assign(DMPmax=lambda x: (x['DMPeffall'] * x['rad_u']))

    #Adding cropsar to the dataframe
    ts_df = ts_df.assign(DMP=lambda x: (x['DMPmax'] * x['cropsar']))

    #unit = 2
    if unit == 2:
        ts_df['DMP'] = ts_df['DMP'] * 0.45 * 0.1
    if GDMPorDMP == 'DMP':
        ts_df['DMP'] = ts_df['DMP'] * f_DMPfraction

    #ts_df.index = pd.to_datetime(ts_df.index).date

    ts_df.index = pd.to_datetime(ts_df.index, format='%Y-%m-%d')
    ts_df.index = pd.to_datetime(ts_df.index).date
    ## remove the applied date shift for calculating cropsar to align again with the requested time_range
    ts_df = ts_df.loc[pd.to_datetime(time_range[0], format = '%Y-%m-%d').date() :pd.to_datetime(time_range[1], format = '%Y-%m-%d').date()]
    ts_df.index = ts_df.index.astype(str)

    dmp_df = ts_df.loc[: , ['DMP']].copy().sort_index().T.round(decimals=5)

    udf_data.set_structured_data_list([StructuredData(description="biomass_dmp", data=dmp_df.to_dict(), type="dict")])

    return udf_data

