from openeo_udf.api.udf_data import UdfData
from openeo_udf.api.structured_data import StructuredData
from openeo.rest.conversions import timeseries_json_to_pandas
import pandas as pd
#import sys
#sys.path.append(r'/data/users/Public/bontek/Nextland/Anomaly_detection/cropsar-1.4.7-py3-none-any.whl') #TODO TO remove
from cropsar.preprocessing.retrieve_timeseries_openeo import run_cropsar_dataframes


#calculate the cropsar curve for each field and the regional average of all the input fields
######## FUNCTIONS ################
def get_cropsar_TS(ts_df, unique_ids_fields, metrics_order, time_range,Spark = True):
    index_fAPAR = metrics_order.index('FAPAR')
    df_S2 = ts_df.loc[:, ts_df.columns.get_level_values(1).isin([str(index_fAPAR)])].sort_index().T

    df_VHVV = ts_df.loc[:, ts_df.columns.get_level_values(1).isin([str(0), str(1)])].sort_index().T
    cropsar_df, cropsar_df_q10, cropsar_df_q90 = run_cropsar_dataframes(df_S2, df_VHVV, None, scale=1, offset=0)
    cropsar_df = cropsar_df.rename(columns = dict(zip(list(cropsar_df.columns.values), [str(item)+ '_cropSAR' for item in unique_ids_fields])))
    cropsar_df.index = pd.to_datetime(cropsar_df.index).date
    cropsar_df = cropsar_df.loc[pd.to_datetime(time_range[0], format = '%Y-%m-%d').date() :pd.to_datetime(time_range[1], format = '%Y-%m-%d').date()]
    return cropsar_df

def udf_anomaly_detection(udf_data:UdfData):
    ## constants
    user_context = udf_data.user_context
    time_range = user_context.get('date')
    columns_order = ['VH', 'VV', 'FAPAR']
    
    ## load the TS
    ts_dict = udf_data.get_structured_data_list()[0].data
    if not ts_dict:  # workaround of ts_dict is empty
        return
    TS_df = timeseries_json_to_pandas(ts_dict)
    TS_df.index = pd.to_datetime(TS_df.index).date

    if not isinstance(TS_df.columns, pd.MultiIndex):
        TS_df.columns = pd.MultiIndex.from_product([[0], TS_df.columns])

    amount_fields = next(iter(ts_dict.values()))
    unique_ids_fields = ['Field_{}'.format(str(p)) for p in range(len(amount_fields))]


    ts_df_cropsar = get_cropsar_TS(TS_df, unique_ids_fields, columns_order, time_range)
    

    #calculate the regional greenness curve
    ts_df_cropsar['Regional_average'] = ts_df_cropsar.mean(axis = 1)
    ts_df_cropsar.index = ts_df_cropsar.index.astype(str)

    udf_data.set_structured_data_list([StructuredData(description= 'anomaly_detection', data = ts_df_cropsar.to_dict(), type = "dict")])


    return udf_data