######################################################################################################
# Cropsar_service.py
# ---------------------------
# Purpose
#       Build OpenEO Cropsar service
#
######################################################################################################

#imports
import json
import pandas as pd
import geopandas as gpd
import openeo
import os
from openeo.api.process import Parameter
from openeo.internal.graph_building import PGNode
from openeo.rest.datacube import DataCube
from openeo.rest.udp import build_process_dict
from openeo.processes import date_shift, array_element
from nextland_services.helper_functions import get_sentinel_datacubes_for_cropsar, preprocessing_datacube_for_udf, get_input_datacube_udf_cropsar



from nextland_services.constants import *

OUTPUT_DIR = r'/data/sigma/Nextland/Development/Openeo/Cropsar/'
OUTPUT_DIR_GRAPH = RESOURCES


# Functions

def _get_epsg(lat, zone_nr):
    if lat >= 0:
        epsg_code = '326' + str(zone_nr)
    else:
        epsg_code = '327' + str(zone_nr)
    return int(epsg_code)

def load_udf(udf):
    with open(Path(__file__).parent / udf, 'r+', encoding= "utf8") as f:
        return f.read()

#Write content to named file
def fwrite(fname, fcontent):
    f = open(fname, 'w')
    f.write(str(fcontent))
    f.close()





# Test the anomaly detection with an UDF
def test_run_udf_cropsar(eoconn,time_range, shp):
    TS_cube = get_input_datacube_udf_cropsar(eoconn, time_range, shp, biopar_fixed= True)
    #TS = TS_cube.send_job().start_and_wait().get_result().load_json()
    #TS = TS_cube.execute()
    # with open(r'/data/sigma/Nextland/Development/Openeo/Cropsar/Test_TS/FIELD_TS_20190701_20190831_test_biopar_selec.json', 'r') as f:
    #         json.dump(TS, f)

    cropsar_code = load_udf("Cropsar_udf.py")

    udf = TS_cube.process("run_udf", data = TS_cube, udf = cropsar_code, runtime = "Python", context = dict({'date': time_range}))

    res = udf.send_job().start_and_wait().get_result().load_json()
    return res


def test_debug_cropsar_udf():
    os.chdir(r'/home/bontek/git/nextland_official/src/nextland_services')
    from openeo_udf.api.udf_data import UdfData
    from openeo_udf.api.structured_data import StructuredData
    from Cropsar_udf import udf_cropsar
    with open(r'/data/sigma/Nextland/Development/Openeo/Cropsar/Test_TS/FIELD_TS_20210801_20210915_test_biopar_selec.json',
              'r') as json_file:
        ts = json.load(json_file)
        udfdata = UdfData({"EPSG":4326}, structured_data_list=[StructuredData(description= "timeseries input", data = ts, type = "dict")])
        udfdata.user_context =  {"date":time_range}
        res = udf_cropsar(udfdata)
        fwrite(os.path.join(OUTPUT_DIR, 'cropsar_testudf_result.res'), res.to_dict())



# Build graph cropsar and write it away as a JSON file
def cropsar_build_graph_poly_and_store_udp(eoconn):
    from helpers import load_markdown
    #Define the service parameters
    time_range = date_parameter("Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    # file_polygons = Parameter.string(
    #     name = "file_polygons", description= 'Path to a geojson file', default = None
    # )
    biopar_type = biopar_parameter()
    polygon = polygon_param(description="A geojson polygon on which to compute the CropSAR timeseries.")

    udf = cropsar_cube(eoconn, polygon, time_range, biopar_type)

    #Build service dict
    cropsar_dict = build_process_dict(
        process_id= "CropSAR",
        description=load_markdown("cropsar.md"),
        process_graph= udf,
        parameters= [time_range, polygon, biopar_type]
    )

    cropsar_dict["examples"]=[
        {"arguments": {
                "time_range": ["2020-02-01","2020-12-01"],
                "polygon": { "type": "Polygon", "coordinates":  [ [ [ 2.970823, 51.117772 ], [ 2.973034, 51.118145 ], [ 2.974201, 51.116564 ], [ 2.973737, 51.116417 ], [ 2.973671, 51.116352 ], [ 2.973688, 51.11626 ], [ 2.974088, 51.115748 ], [ 2.973778, 51.115665 ], [ 2.973777, 51.115664 ], [ 2.973153, 51.115491 ], [ 2.972811, 51.11547 ], [ 2.970823, 51.117772 ] ] ]  }
        },
        "returns": {"Field_0_cropSAR":{"2020-02-01":0.9301172494888306,"2020-02-02":0.9315246343612671,"2020-02-03":0.9324730634689331,"2020-02-04":0.9329112768173218,"2020-02-05":0.9325883984565735,"2020-02-06":0.931118369102478,"2020-02-07":0.927969217300415,"2020-02-08":0.9248553514480591,"2020-02-09":0.9217768907546997,"2020-02-10":0.9179251194000244,"2020-02-11":0.913640022277832,"2020-02-12":0.9095489978790283,"2020-02-13":0.9066181182861328,"2020-02-14":0.9050941467285156,"2020-02-15":0.9048548340797424,"2020-02-16":0.904588520526886,"2020-02-17":0.90351402759552,"2020-02-18":0.9021998643875122,"2020-02-19":0.9011940956115723,"2020-02-20":0.9017857313156128,"2020-02-21":0.904306173324585,"2020-02-22":0.9070756435394287,"2020-02-23":0.9081984162330627,"2020-02-24":0.9083003401756287,"2020-02-25":0.9046710729598999,"2020-02-26":0.903674840927124,"2020-02-27":0.9086235761642456,"2020-02-28":0.9106292724609375,"2020-02-29":0.9139195680618286,"2020-03-01":0.9247603416442871,"2020-03-02":0.9353123307228088,"2020-03-03":0.941375732421875,"2020-03-04":0.9416886568069458,"2020-03-05":0.9436155557632446,"2020-03-06":0.9458191990852356,"2020-03-07":0.9398554563522339,"2020-03-08":0.9322232007980347,"2020-03-09":0.926548957824707,"2020-03-10":0.9237639904022217,"2020-03-11":0.9205986261367798,"2020-03-12":0.9151399731636047,"2020-03-13":0.9163077473640442,"2020-03-14":0.9172636866569519,"2020-03-15":0.9184682369232178,"2020-03-16":0.9190995693206787,"2020-03-17":0.921768307685852,"2020-03-18":0.9274771213531494,"2020-03-19":0.9329513311386108,"2020-03-20":0.9339643716812134,"2020-03-21":0.9318870306015015,"2020-03-22":0.9289504289627075,"2020-03-23":0.9331459999084473,"2020-03-24":0.9359114766120911,"2020-03-25":0.9369068741798401,"2020-03-26":0.934898853302002,"2020-03-27":0.9272109866142273,"2020-03-28":0.9175852537155151,"2020-03-29":0.9078340530395508,"2020-03-30":0.9012933969497681,"2020-03-31":0.8966124653816223,"2020-04-01":0.8928114175796509,"2020-04-02":0.8922381401062012,"2020-04-03":0.889781653881073,"2020-04-04":0.8878082633018494,"2020-04-05":0.8879178762435913,"2020-04-06":0.8895174264907837,"2020-04-07":0.8938865661621094,"2020-04-08":0.8994402885437012,"2020-04-09":0.9023783206939697,"2020-04-10":0.9057377576828003,"2020-04-11":0.9110373258590698,"2020-04-12":0.9142366051673889,"2020-04-13":0.9172369241714478,"2020-04-14":0.923198938369751,"2020-04-15":0.9229388236999512,"2020-04-16":0.9306694269180298,"2020-04-17":0.9447451829910278,"2020-04-18":0.9585520029067993,"2020-04-19":0.964794397354126,"2020-04-20":0.9641287326812744,"2020-04-21":0.9624106287956238,"2020-04-22":0.9584100246429443,"2020-04-23":0.9534231424331665,"2020-04-24":0.9488453269004822,"2020-04-25":0.9436968564987183,"2020-04-26":0.9413712024688721,"2020-04-27":0.9415469169616699,"2020-04-28":0.9432353973388672,"2020-04-29":0.9462177753448486,"2020-04-30":0.9411990642547607,"2020-05-01":0.9390549659729004,"2020-05-02":0.9424729347229004,"2020-05-03":0.9477380514144897,"2020-05-04":0.948940634727478,"2020-05-05":0.9392673969268799,"2020-05-06":0.9120173454284668,"2020-05-07":0.8399393558502197,"2020-05-08":0.7249807715415955,"2020-05-09":0.5400038361549377,"2020-05-10":0.3784680664539337,"2020-05-11":0.27807754278182983,"2020-05-12":0.20565402507781982,"2020-05-13":0.1662798523902893,"2020-05-14":0.1319076120853424,"2020-05-15":0.11001729965209961,"2020-05-16":0.09714090824127197,"2020-05-17":0.09827426075935364,"2020-05-18":0.10803601145744324,"2020-05-19":0.11870139837265015,"2020-05-20":0.12507659196853638,"2020-05-21":0.12847280502319336,"2020-05-22":0.13450050354003906,"2020-05-23":0.13595998287200928,"2020-05-24":0.13203412294387817,"2020-05-25":0.12721258401870728,"2020-05-26":0.12340927124023438,"2020-05-27":0.12178832292556763,"2020-05-28":0.1222265362739563,"2020-05-29":0.1279909312725067,"2020-05-30":0.13891372084617615,"2020-05-31":0.151289165019989,"2020-06-01":0.16304552555084229,"2020-06-02":0.16880565881729126,"2020-06-03":0.16983124613761902,"2020-06-04":0.171558678150177,"2020-06-05":0.17390719056129456,"2020-06-06":0.17619508504867554,"2020-06-07":0.17853900790214539,"2020-06-08":0.18143224716186523,"2020-06-09":0.1854247748851776,"2020-06-10":0.1907983422279358,"2020-06-11":0.19384443759918213,"2020-06-12":0.19326967000961304,"2020-06-13":0.19446247816085815,"2020-06-14":0.19703006744384766,"2020-06-15":0.20050600171089172,"2020-06-16":0.2052111029624939,"2020-06-17":0.20886045694351196,"2020-06-18":0.2155490517616272,"2020-06-19":0.22261303663253784,"2020-06-20":0.22852951288223267,"2020-06-21":0.23095378279685974,"2020-06-22":0.2313879132270813,"2020-06-23":0.23471230268478394,"2020-06-24":0.24360457062721252,"2020-06-25":0.2599620819091797,"2020-06-26":0.27921587228775024,"2020-06-27":0.31580308079719543,"2020-06-28":0.3617948889732361,"2020-06-29":0.4027778208255768,"2020-06-30":0.44273048639297485,"2020-07-01":0.47150760889053345,"2020-07-02":0.5007685422897339,"2020-07-03":0.5372020602226257,"2020-07-04":0.5764315724372864,"2020-07-05":0.6198479533195496,"2020-07-06":0.653388261795044,"2020-07-07":0.6749441623687744,"2020-07-08":0.6913940906524658,"2020-07-09":0.7070055603981018,"2020-07-10":0.7228952646255493,"2020-07-11":0.7357632517814636,"2020-07-12":0.7509465217590332,"2020-07-13":0.7665412425994873,"2020-07-14":0.7805291414260864,"2020-07-15":0.7924813032150269,"2020-07-16":0.8039877414703369,"2020-07-17":0.8147063255310059,"2020-07-18":0.8238919973373413,"2020-07-19":0.8318462371826172,"2020-07-20":0.8376286625862122,"2020-07-21":0.8409647941589355,"2020-07-22":0.842535674571991,"2020-07-23":0.8398553133010864,"2020-07-24":0.8363509774208069,"2020-07-25":0.8328554034233093,"2020-07-26":0.8339532613754272,"2020-07-27":0.8439714312553406,"2020-07-28":0.8574625849723816,"2020-07-29":0.870771050453186,"2020-07-30":0.8818651437759399,"2020-07-31":0.8889550566673279,"2020-08-01":0.8959001302719116,"2020-08-02":0.9059389233589172,"2020-08-03":0.9119123220443726,"2020-08-04":0.9163476824760437,"2020-08-05":0.9175513982772827,"2020-08-06":0.9155294299125671,"2020-08-07":0.908039391040802,"2020-08-08":0.8995950222015381,"2020-08-09":0.8894928693771362,"2020-08-10":0.8795337080955505,"2020-08-11":0.8681273460388184,"2020-08-12":0.8627453446388245,"2020-08-13":0.8518123030662537,"2020-08-14":0.8427334427833557,"2020-08-15":0.8364594578742981,"2020-08-16":0.8326276540756226,"2020-08-17":0.8303433656692505,"2020-08-18":0.8275155425071716,"2020-08-19":0.8267444372177124,"2020-08-20":0.8254973888397217,"2020-08-21":0.8240251541137695,"2020-08-22":0.8199451565742493,"2020-08-23":0.8215050101280212,"2020-08-24":0.8277484774589539,"2020-08-25":0.8273541927337646,"2020-08-26":0.822806179523468,"2020-08-27":0.8214328289031982,"2020-08-28":0.8162775039672852,"2020-08-29":0.8077679872512817,"2020-08-30":0.7987524271011353,"2020-08-31":0.7918552756309509,"2020-09-01":0.7929844856262207,"2020-09-02":0.798778772354126,"2020-09-03":0.8075199127197266,"2020-09-04":0.8187112212181091,"2020-09-05":0.831092119216919,"2020-09-06":0.8425397872924805,"2020-09-07":0.8509886860847473,"2020-09-08":0.8554449677467346,"2020-09-09":0.8600935935974121,"2020-09-10":0.8649993538856506,"2020-09-11":0.8707392811775208,"2020-09-12":0.8787002563476562,"2020-09-13":0.880570650100708,"2020-09-14":0.8833988904953003,"2020-09-15":0.8850821256637573,"2020-09-16":0.8826310038566589,"2020-09-17":0.877289891242981,"2020-09-18":0.8681434392929077,"2020-09-19":0.8642889261245728,"2020-09-20":0.8599662184715271,"2020-09-21":0.8519018888473511,"2020-09-22":0.8388810753822327,"2020-09-23":0.8292469382286072,"2020-09-24":0.819514274597168,"2020-09-25":0.8054684400558472,"2020-09-26":0.7928160429000854,"2020-09-27":0.7883403301239014,"2020-09-28":0.783637523651123,"2020-09-29":0.7807203531265259,"2020-09-30":0.7768341898918152,"2020-10-01":0.7706105709075928,"2020-10-02":0.7587882280349731,"2020-10-03":0.7010947465896606,"2020-10-04":0.5773261189460754,"2020-10-05":0.4210808277130127,"2020-10-06":0.2997877895832062,"2020-10-07":0.22857075929641724,"2020-10-08":0.19383877515792847,"2020-10-09":0.18381577730178833,"2020-10-10":0.1809331178665161,"2020-10-11":0.17795458436012268,"2020-10-12":0.1748288869857788,"2020-10-13":0.17302030324935913,"2020-10-14":0.1723536252975464,"2020-10-15":0.1726280152797699,"2020-10-16":0.17372378706932068,"2020-10-17":0.17568260431289673,"2020-10-18":0.17886334657669067,"2020-10-19":0.1816536784172058,"2020-10-20":0.18324804306030273,"2020-10-21":0.18301606178283691,"2020-10-22":0.18076419830322266,"2020-10-23":0.17854389548301697,"2020-10-24":0.17655730247497559,"2020-10-25":0.17636701464653015,"2020-10-26":0.179514080286026,"2020-10-27":0.1856159269809723,"2020-10-28":0.1920701265335083,"2020-10-29":0.19537043571472168,"2020-10-30":0.19463002681732178,"2020-10-31":0.19231849908828735,"2020-11-01":0.18412911891937256,"2020-11-02":0.1772603988647461,"2020-11-03":0.1739283800125122,"2020-11-04":0.1729610562324524,"2020-11-05":0.17277473211288452,"2020-11-06":0.17163580656051636,"2020-11-07":0.16737091541290283,"2020-11-08":0.16121602058410645,"2020-11-09":0.1566537320613861,"2020-11-10":0.15519630908966064,"2020-11-11":0.15318113565444946,"2020-11-12":0.15330982208251953,"2020-11-13":0.1593095064163208,"2020-11-14":0.16503041982650757,"2020-11-15":0.1704522967338562,"2020-11-16":0.178063303232193,"2020-11-17":0.18510553240776062,"2020-11-18":0.19141101837158203,"2020-11-19":0.196976900100708,"2020-11-20":0.20146822929382324,"2020-11-21":0.20457664132118225,"2020-11-22":0.20621156692504883,"2020-11-23":0.20585083961486816,"2020-11-24":0.20375406742095947,"2020-11-25":0.20054233074188232,"2020-11-26":0.19728511571884155,"2020-11-27":0.19517940282821655,"2020-11-28":0.1950991451740265,"2020-11-29":0.19690439105033875,"2020-11-30":0.19987109303474426,"2020-12-01":0.2064761221408844}}
        }
    ]
    #Write service graph to json file

    fwrite(os.path.join(OUTPUT_DIR_GRAPH, 'cropsar_graph.json'), json.dumps(cropsar_dict, indent = 4))


def cropsar_cube(eoconn, file_polygons, time_range, biopar_type = 'FAPAR'):
    timeseries_input = get_input_datacube_udf_cropsar(eoconn, time_range, file_polygons, biopar_type = 'FAPAR')
    # load UDF
    cropsar_code = load_udf("Cropsar_udf.py")
    udf = timeseries_input.process("run_udf", data=timeseries_input, udf=cropsar_code, runtime="Python",
                                   context = {"date": {"from_parameter": "date"}})
    return udf


def save_udp(eoconn):
    # Define the service parameters
    time_range = date_parameter("Left-closed temporal interval, i.e. an array with exactly two elements:\n\n1. The first element is the start of the temporal interval. The specified instance in time is **included** in the interval.\n2. The second element is the end of the temporal interval. The specified instance in time is **excluded** from the interval.\n\nThe specified temporal strings follow [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339.html). Also supports open intervals by setting one of the boundaries to `null`, but never both.")
    biopar_type =  biopar_parameter()
    polygon = polygon_param(description="A geojson polygon on which to compute the CropSAR timeseries.")
    with open(os.path.join(OUTPUT_DIR_GRAPH,'cropsar_graph.json'),'r') as file:
        graph = json.load(file)
    udp = eoconn.save_user_defined_process(
        'CropSAR',
        graph["process_graph"],
        description= "Calculates the cropsar curve for each field over the given time range.",
        parameters=[time_range, polygon, biopar_type], public=True)

def run_nexland_service():
    year = 2021
    ID_identifier = 'name'
    time_range = '{}-01-01'.format(str(year)),'{}-11-20'.format(str(year))
    gpd_shp = gpd.read_file(r'/data/sigma/Nextland/BDB/In_situ/Irrigation_advice_WGS84.shp')
    js_shp = json.loads(gpd_shp.to_json())
    biopars = ['FAPAR', 'FCOVER']
    for biopar in biopars:
        outdir_nextland = r'/data/sigma/Nextland/BDB/Products/Cropsar/Irrigation_advice/{}/{}'.format(str(year),biopar)
        os.makedirs(outdir_nextland, exist_ok= True)
        for poly in js_shp['features']:
            polyid = poly['properties'][ID_identifier]
            polyg = poly['geometry']
            if not os.path.exists(os.path.join(outdir_nextland,"CROPSAR_2021_NRT_{}_{}.csv".format(biopar,polyid))):
                cropsar_curve= eoconn.datacube_from_process('CropSAR', date = time_range, polygon = polyg, biopar_type = biopar).send_job().start_and_wait().get_result().load_json()
                df_cropsar = pd.DataFrame.from_dict(cropsar_curve)
                df_cropsar.to_csv(os.path.join(outdir_nextland,"CROPSAR_2021_NRT_{}_{}.csv".format(biopar,polyid)), index = True)

gjson_file = r'/data/users/Public/bontek/Nextland/CropSAR/parcel-in-retie_geom.geojson'
with open(gjson_file) as f: geom = json.load(f)
time_range= '2021-08-01','2021-09-15'
eoconn = openeo.connect("http://openeo-dev.vgt.vito.be").authenticate_basic('bontek', 'bontek123')
#test_run_udf_cropsar(eoconn, time_range, geom)
#test_debug_cropsar_udf()
#cropsar_build_graph_poly_and_store_udp(eoconn)
#save_udp(eoconn)

run_nexland_service()


# import pandas as pd
#cropsar_curve= eoconn.datacube_from_process('CropSAR', date = time_range, polygon = geom, biopar_type = 'FAPAR').send_job().start_and_wait().get_result().load_json()
# df_cropsar = pd.DataFrame.from_dict(cropsar_curve)
# df_cropsar.to_csv(os.path.join(OUTPUT_DIR_GRAPH,"reference_result_CropSAR_FAPAR.csv"), index = True)