"""Load and process data."""

from vito_crop_classification.data_io.loaders import (
    load_data,
    load_datasets,
    load_datasets_from_cfg,
    load_time_folds,
)
from vito_crop_classification.data_io.outliers import detect_and_prune_outliers
from vito_crop_classification.data_io.splits import save_splits

__all__ = [
    "detect_and_prune_outliers",
    "load_datasets",
    "load_time_folds",
    "load_datasets_from_cfg",
    "load_data",
    "save_splits",
]
