"""Base configuration files."""

from __future__ import annotations

import json
from pathlib import Path
from typing import Any


def get_cfg(cfg_tag: str = "dense") -> dict[str, Any]:
    """Get model configuration file."""
    with open(Path(__file__).parent / f"cfg_{cfg_tag}.json", "r") as f:
        return json.load(f)
