import json
import csv
import argparse
import requests
from shapely import wkt
from shapely.geometry import mapping, shape
from requests.auth import HTTPBasicAuth
from cropclass.utils.s3_helpers import create_s3_obj, create_s3_bucket
import os


def push_STAC_to_catalog(STAC, row, catalog = 'CROPTYPE_RAW_v0'):
    user = os.environ['GAF_USER']
    pw = os.environ['GAF_PW']
    res = requests.get('https://vlcc.geoville.com/resto/auth', auth=HTTPBasicAuth(user, pw))
    TOKEN = json.loads(res.text)["token"]

    #create payload
    output = {"type": "Feature",
              "stac_version": STAC["stac_version"],
              "stac_extensions": STAC["stac_extensions"],
              "id": row['title'].split('-')[0],
              "proj:bbox": STAC["assets"][row['title'].replace('_RAW.tif','.tif')]["proj:bbox"],
              "proj:epsg": STAC["assets"][row['title'].replace('_RAW.tif','.tif')]["proj:epsg"],
              "proj:shape": STAC["assets"][row['title'].replace('_RAW.tif','.tif')]["proj:shape"],
              "geometry": mapping(shape(row["geometry"])),
              "properties": {
                  "proj:epsg": 3035,
                  "startDate": f"{row['year']}-01-01T00:00:00.000Z",
                  "completionDate": f"{row['year']}-12-31T23:59:59.999Z"
              },

              "collection": catalog,
              "assets":
                  {"result":{"href":  's3://products/'+ create_s3_obj(row, 'raw') ,"type":"image/tiff"},
                   "eo:bands" : STAC["assets"][row['title'].replace('_RAW.tif','.tif')]["eo:bands"],},
              "links": []}

    payload = json.dumps(output)
    res = requests.get('https://vlcc.geoville.com/resto/auth', auth=HTTPBasicAuth(user, pw))
    token = json.loads(res.text)["token"]
    url = "https://vlcc.geoville.com/resto/collections/{}/items".format(catalog)
    headers = {
        'accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + token
    }

    response = requests.request("POST", url, headers=headers, data=payload)

