import json
import argparse
import requests
from requests.auth import HTTPBasicAuth


if __name__ == '__main__':

    parser = argparse.ArgumentParser(description='Create collection in VLCC resto.')
    parser.add_argument('--user', type=str, required=True)
    parser.add_argument('--pw', type=str, required=True)
    parser.add_argument('--json_path', type=str, required=True)

    args = parser.parse_args()

    user = args.user
    pw = args.pw
    json_path = args.json_path
    f = open(json_path)
    config = json.load(f)
    print("Create new Collection with: ")
    print(config)

    res = requests.get('https://vlcc.geoville.com/resto/auth', auth=HTTPBasicAuth(user, pw))
    TOKEN = json.loads(res.text)["token"]

    fin = open("collection.json", "rt")
    text = ""
    for line1 in fin:
        text += line1.replace('<id>', config["id"]) \
            .replace('<description>', config["description"]) \
            .replace('<title>', config["title"])
    fin.close()
    url = "https://vlcc.geoville.com/resto/collections"
    payload = json.dumps(json.loads(text))
    headers = {
        'accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + TOKEN
    }

    response = requests.request("POST", url, headers=headers, data=payload)
    print("Result:")
    print(response.text)

