import json
import csv
import argparse
import requests
from requests.auth import HTTPBasicAuth


def resto_item(token, conf, collection_id, data):
    fin = open("feature.json", "rt")
    text = ""
    for line in fin:
        text += line.replace('<tile_id>', str(conf["id"]))\
            .replace('<minx>', str(data[0]))\
            .replace('<maxx>', str(data[1]))\
            .replace('<miny>', str(data[2]))\
            .replace('<maxy>', str(data[3])) \
            .replace('<collection_id>', collection_id) \
            .replace('<year>', str(conf["year"])) \
            .replace('<assets>', json.dumps(conf["assets"]))
    fin.close()
    url = "https://vlcc.geoville.com/resto/collections/{}/items".format(collection_id)
    print(text)
    payload = json.dumps(json.loads(text))
    print(payload)
    headers = {
        'accept': 'application/json',
        'Content-Type': 'application/json',
        'Authorization': 'Bearer ' + token
    }

    response = requests.request("POST", url, headers=headers, data=payload)

    print(response.text)


if __name__ == '__main__':

    parser = argparse.ArgumentParser(description='Insert items to a collection in VLCC resto.')
    parser.add_argument('--user', type=str, required=True)
    parser.add_argument('--pw', type=str, required=True)
    parser.add_argument('--json_path', type=str, required=True)

    args = parser.parse_args()

    user = args.user
    pw = args.pw
    json_path = args.json_path
    f = open(json_path)
    config = json.load(f)
    print("Create new Features with: ")
    print(config)

    res = requests.get('https://vlcc.geoville.com/resto/auth', auth=HTTPBasicAuth(user, pw))
    TOKEN = json.loads(res.text)["token"]
    print(TOKEN)

    data_dict = {}
    with open("europe_100km_EEA38_4326.csv", newline='') as csvfile:
        reader = csv.DictReader(csvfile)
        for row in reader:
            data_dict[row['id']] = (float(row['minx']), float(row['maxx']), float(row['miny']), float(row['maxy']))

    for f in config["features"]:
        resto_item(TOKEN, f, config["collection_id"], data_dict.get(f["id"], None))

