'''
These helpers include function that are needed to get some things done on S3.
To run these script aws cli is needed and ID and secret put into vlcc profile.
You can get this info from T Cassaert or another member of openeo team.
'''

import os
#get aws cli profile with credentials
os.environ['AWS_PROFILE'] = 'vlcc'
import subprocess
import time
import boto3

def check_create_bucket(s3_bucket, endpoint_url='https://s3.waw3-1.cloudferro.com/'):
    '''
    Function to create buckets on S3. It first does a check if the bucket exists then creates bucket.
    :param s3_bucket: S3 bucket that is going to be created.
    :param endpoint_url: endpoint that's going to be used to create the bucket
    '''
    s3 = boto3.client('s3', endpoint_url=endpoint_url)

    try:
        s3.head_bucket(Bucket=s3_bucket)
    except :
        print('Create Bucket')
        result = s3.create_bucket(Bucket=s3_bucket)

        '''
        #add this moment no ACL's defined
        print("set ACL's")
        result = subprocess.run(['aws','s3api','--profile','vlcc','--endpoint-url' ,'https://s3.waw3-1.cloudferro.com/', 'put-bucket-policy',
                                 '--policy','file://home/user/sentinel2biopar/bucket_policy.json', '--bucket', s3_bucket],
                                stdout = subprocess.PIPE,
                                stderr = subprocess.PIPE)
        '''
    print('s3 bucket {0} exists'.format(s3_bucket))

def copy_to_s3(tmp_file, s3_bucket, s3_key, target_s3_endpoint = 'https://s3.waw3-1.cloudferro.com/', retry=0):
    '''
    Function to create buckets on S3. It first does a check if the bucket exists then creates bucket returns true or false for, success or fail
    :param tmp_file: name of file that needs to be upload
    :param s3_bucket: S3 bucket where files is going to upload to.
    :param s3_key: name of s3-object
    :param target_s3_endpoint: endpoint that's going to be used to create the bucket
    '''
    check_create_bucket(s3_bucketo)

    s3 = boto3.client('s3', endpoint_url=target_s3_endpoint)

    time_start = time.perf_counter()

    print(f'Upload {tmp_file} to {s3_bucket}/{s3_key}')
    try:
        result = s3.upload_file(tmp_file,s3_bucket,s3_key)
    except ClientError as e:
        #first retry
        if retry < 5:
            time.sleep(60)
            copy_to_s3(tmp_file, s3_bucket, s3_key, target_s3_endpoint='https://s3.waw3-1.cloudferro.com/',
                       retry=retry+1)
        else:
            raise Exception('Copying data to S3 failed: ' + str(result.stderr))


    time_end = time.perf_counter()

    print('Successfully copied data to S3 in {0} s'.format(time_end - time_start))