


def croptype_colors():
    """
    Returns a color map that can be used with openEO.
    Returns:

    """
    from matplotlib.colors import ListedColormap
    col_palette = [
        [174, 199, 232, 255],  # (Barley)#0
        [214, 39, 40, 255],  # (Dry Pulses)
        [247, 182, 210, 255],  # (Flaxcotton and hemp)
        [219, 219, 141, 255],  # (Fruits)
        [199, 199, 199, 255],  # (Grapes)
        [127, 127, 127, 255],  # (Grass and foddercrops)#5
        [255, 127, 14, 255],  # (Maize) #6
        [23, 190, 207, 255],  # (Nuts)
        [152, 223, 138, 255],  # (Oats)
        [188, 189, 34, 255],  # (Olives)
        [148, 103, 189, 255],  # (Potatoes) #10
        [227, 119, 194, 255],  # (Rapeseed)
        [255, 187, 120, 255],  # (Rice)
        [44, 160, 44, 255],  # (Rye)
        [196, 156, 148, 255],  # (Soybeans)
        [197, 176, 213, 255],  # (SugarBeet) #15
        [140, 86, 75, 255],  # (Sunflower)
        [255, 152, 150, 255],  # (Fresh Vegetables)
        [31, 119, 180, 255]  # (Wheat)
    ]
    cmap = ListedColormap(col_palette)
    classification_colors = {x: [c / 255.0 for c in cmap(x)] for x in range(0, len(col_palette))}
    return classification_colors
