"""Transform raw data inputs into encoded embeddings."""

from vito_crop_classification.model.encoders.base import BaseEncoder
from vito_crop_classification.model.encoders.concatenate import ConcatenatedEncoder
from vito_crop_classification.model.encoders.dense import DenseEncoder
from vito_crop_classification.model.encoders.identity import IdentityEncoder
from vito_crop_classification.model.encoders.loaders import load_encoder, parse_encoder
from vito_crop_classification.model.encoders.rnn import RnnEncoder, RnnType
from vito_crop_classification.model.encoders.transformer import Aggregate, TransformerEncoder
from vito_crop_classification.model.encoders.utils import (
    extract_sc,
    extract_ts,
    get_extract_function,
)

__all__ = [
    "Aggregate",
    "BaseEncoder",
    "ConcatenatedEncoder",
    "DenseEncoder",
    "extract_sc",
    "extract_ts",
    "get_extract_function",
    "load_encoder",
    "parse_encoder",
    "RnnType",
    "RnnEncoder",
    "IdentityEncoder",
    "TransformerEncoder",
]
