"""Lookup-tables used by the processing functions."""

from __future__ import annotations

from functools import lru_cache

LEVEL_3 = {
    "1-1-1-1s": ["^11-01-01-...-2"],
    "1-1-1-1w": ["^11-01-01-...-1"],
    "1-1-1-2w": ["^11-01-02-...-1"],
    "1-1-1-2s": ["^11-01-02-...-2"],
    "1-1-1-3w": ["^11-01-03-...-1"],
    "1-1-1-3s": ["^11-01-03-...-2"],
    "1-1-1-4w": ["^11-01-04-...-1"],
    "1-1-1-4s": ["^11-01-04-...-2"],
    "1-1-1-5w": ["^11-01-05-...-1"],
    "1-1-1-5s": ["^11-01-05-...-2"],
    "1-1-1-11": ["^11-01-07-001-0", "^11-01-07-002-0"],
    # "1-1-1-12":	["11-01-09-000-0"],
    "1-1-1-13": ["^11-01-10-000-0"],
    "1-1-2-1": ["^11-01-06-.*"],
    "1-1-2-2": ["^11-01-07-003-0", "^11-01-07-004-0"],
    "1-1-3-0": ["^11-01-08-.*"],
    "1-2-1-0": ["^11-03-.*"],
    "1-2-2-1": ["^11-05-01-.*"],
    "1-2-2-2": ["^11-05-00-.*"],
    "1-3-1-0": ["^11-07-00-001-.*"],
    "1-3-2-0": ["^11-07-00-003-.*"],
    "1-4-1-0": ["^11-06-00-001-0"],
    "1-4-2-0": ["^11-06-00-002-0"],
    "1-4-3-0": ["^11-06-00-003-.*"],
    "1-4-4-0": ["^11-08-00-.*", "^11-08-01-.*", "^11-09-00-053-.*"],
    "1-5-1-0": ["^11-11-00-001-0", "^11-11-01-.*", "^13-.*"],
    "1-5-2-0": ["^11-11-02-.*", "^11-11-04-.*"],
    "2-1-0-0": ["^12-01-00-001-.*"],
    "2-2-0-0": ["^12-03-00-001-.*"],
    "2-3-1-1": ["^12-01-01-.*"],
    "2-3-1-2": ["^12-01-03-.*"],
    "2-3-1-3": ["^12-01-05-.*"],
    "2-3-2-0": ["^12-01-04-.*"],
}

LEVEL_2 = {  # no winter-spring, merged other cereals, merged fodder crops
    "1-1-1-1": ["^11-01-01-.*"],
    "1-1-1-2": ["^11-01-02-.*"],
    "1-1-1-3": ["^11-01-03-.*"],
    "1-1-1-4": ["^11-01-04-.*"],
    "1-1-1-5": ["^11-01-05-.*"],
    "1-1-1-10": ["^11-01-07-001-0", "^11-01-07-002-0", "^11-01-09-000-0", "^11-01-10-000-0"],
    "1-1-2-1": ["^11-01-06-.*"],
    "1-1-2-2": ["^11-01-07-003-0", "^11-01-07-004-0"],
    "1-1-3-0": ["^11-01-08-.*"],
    "1-2-1-0": ["^11-03-.*"],
    "1-2-2-1": ["^11-05-01-.*"],
    "1-2-2-2": ["^11-05-00-.*"],
    "1-3-1-0": ["^11-07-00-001-.*"],
    "1-3-2-0": ["^11-07-00-003-.*"],
    "1-4-1-0": ["^11-06-00-001-0"],
    "1-4-2-0": ["^11-06-00-002-0"],
    "1-4-3-0": ["^11-06-00-003-.*"],
    "1-4-4-0": ["^11-08-00-.*", "^11-08-01-.*", "^11-09-00-053-.*"],
    "1-5-0-0": ["^11-11-.*", "^13-.*"],
    "2-1-0-0": ["^12-01-00-001-.*"],
    "2-2-0-0": ["^12-03-00-001-.*"],
    "2-3-1-1": ["^12-01-01-.*"],
    "2-3-1-2": ["^12-01-03-.*"],
    "2-3-1-3": ["^12-01-05-.*"],
    "2-3-2-0": ["^12-01-04-.*"],
}

CROP_LABEL_DESCR = {
    "0-0-0-0": "other",
    "1-0-0-0": "arable_crops",
    "1-1-0-0": "cereals",
    "1-1-1-0": "wheat-like cereals",
    "1-1-1-0w": "winter wheat-like cereals",
    "1-1-1-0s": "spring wheat-like cereals",
    "1-1-1-1": "wheat",
    "1-1-1-1w": "winter_wheat",
    "1-1-1-1s": "spring_wheat",
    "1-1-1-2": "barley",
    "1-1-1-2w": "winter_barley",
    "1-1-1-2s": "spring_barley",
    "1-1-1-3": "rye",
    "1-1-1-3w": "winter_rye",
    "1-1-1-3s": "spring_rye",
    "1-1-1-4": "oats",
    "1-1-1-4w": "winter_oats",
    "1-1-1-4s": "spring_oats",
    "1-1-1-5": "triticale",
    "1-1-1-5w": "winter_triticale",
    "1-1-1-5s": "spring_triticale",
    "1-1-1-10": "other wheat-like cereals",
    "1-1-1-11": "millet",
    "1-1-1-12": "teff",
    "1-1-1-13": "canaryseed",
    "1-1-2-0": "maize-like cereals",
    "1-1-2-1": "maize",
    "1-1-2-2": "sorghum",
    "1-1-3-0": "rice",
    "1-2-0-0": "dry pulses, vegetables",
    "1-2-1-0": "fresh vegetables",
    "1-2-2-0": "dry pulses",
    "1-2-2-1": "peas & beans",
    "1-2-2-2": "other pulses",
    "1-3-0-0": "root/tuber crops",
    "1-3-1-0": "potatoes",
    "1-3-2-0": "sugar beet",
    "1-4-0-0": "non-permanent industrial crops",
    "1-4-1-0": "sunflower",
    "1-4-2-0": "soybeans",
    "1-4-3-0": "rapeseed",
    "1-4-4-0": "flax, cotton, hemp",
    "1-5-0-0": "fodder_crops (incl. grassland)",
    "1-5-1-0": "grassland",
    "1-5-2-0": "fodder crops",
    "2-0-0-0": "permanent_crops",
    "2-1-0-0": "grapes",
    "2-2-0-0": "olives",
    "2-3-0-0": "fruits & nuts",
    "2-3-1-0": "fruits",
    "2-3-1-1": "pome and stone fruit",
    "2-3-1-2": "citrus fruit",
    "2-3-1-3": "berries",
    "2-3-2-0": "nuts",
}


@lru_cache
def get_lut(scenario: int = 1) -> dict[str, list[int]]:
    """Get dictionary containing LUT for specified scenario."""
    res: dict[str, list[int]] = globals()[f"LEVEL_{scenario}"]
    return res


@lru_cache
def get_lut_rev(scenario: int = 1) -> dict[int, str]:
    """Get dictionary containing reverted LUT for specified scenario."""
    res = get_lut(scenario=scenario)
    return {x: k for k, v in res.items() for x in v}
