"""Base configuration files."""

from __future__ import annotations

import json
from pathlib import Path
from typing import Any


def get_transformer_cfg() -> dict[str, Any]:
    """Get the transformer model's basic configuration."""
    with open(Path(__file__).parent / "cfg_transformer.json", "r") as f:
        return json.load(f)


def get_dense_cfg() -> dict[str, Any]:
    """Get the dense model's basic configuration."""
    with open(Path(__file__).parent / "cfg_dense.json", "r") as f:
        return json.load(f)


def get_dense_sim_cfg() -> dict[str, Any]:
    """Get the dense model's basic configuration."""
    with open(Path(__file__).parent / "cfg_dense_sim.json", "r") as f:
        return json.load(f)


def get_concat_cfg() -> dict[str, Any]:
    """Get the concat model's basic configuration."""
    with open(Path(__file__).parent / "cfg_concat.json", "r") as f:
        return json.load(f)


def get_mimic_cfg() -> dict[str, Any]:
    """Get the mimic model's configuration."""
    with open(Path(__file__).parent / "cfg_mimic.json", "r") as f:
        return json.load(f)


def get_sota_optical_cfg() -> dict[str, Any]:
    """Get the mimic model's configuration."""
    with open(Path(__file__).parent / "cfg_sota_optical.json", "r") as f:
        return json.load(f)


def get_sota_optical_sim_cfg() -> dict[str, Any]:
    """Get the mimic model's configuration."""
    with open(Path(__file__).parent / "cfg_sota_optical_sim.json", "r") as f:
        return json.load(f)
