"""Analyse functions."""

from __future__ import annotations

from pathlib import Path

import pandas as pd

from vito_crop_classification.vito_logger import Logger


def analyse(
    df_test: pd.DataFrame,
    df_preds: pd.DataFrame,
    save_dir: Path,
    logger: Logger,
) -> None:
    """Analyse model errors.

    Parameters
    ----------
    df_test : pd.DataFrame
        Dataset used to predict
    df_preds : pd.DataFrame
        Prediction dataset returned by a Predictor
    save_dir : Path
        saving directory
    logger : Logger
        Logger used for tracking code progress
    sensors : list[str] | None, optional
        List of features/sensors to analyse, by default None
    """
    logger("Analysing:")
    logger(f" - Writing results.parquet to {save_dir}..")
    save_dir.mkdir(parents=True, exist_ok=True)
    results = pd.concat([df_test, df_preds], axis=1)
    results.to_parquet(save_dir / "results.parquet")
