from typing import Tuple
import pandas as pd


def doy_to_date(doy, year):
    return pd.to_datetime(
        f'{year}-01-01') + pd.Timedelta(days=doy-1)


def get_processing_dates(start_doy: int,
                         end_doy: int,
                         year: int) -> Tuple[str, str]:
    """Convert start and end day of years
        into processing dates based on a reference year

        Args:
            start_doy (int): start day of year
            end_doy (int): end day of year
            year (int): reference year

        Returns:
            tuple(str, str): start and end processing dates
        """
    if start_doy < end_doy:
        # start is in same year as end
        start_date = doy_to_date(start_doy, year)
    else:
        # start date is in previous year
        start_date = doy_to_date(start_doy, year-1)
    end_date = doy_to_date(end_doy, year)

    return start_date.strftime('%Y-%m-%d'), end_date.strftime('%Y-%m-%d')
