def get_sensor_config(feature_names, pattern=''):

    sensorconfig = {}
    sensorconfig['aux'] = dict(
        channels=len([x for x in feature_names if ('DEM' in x or 'biome' in x)
                      and pattern in x and '-ts' not in x]),
        positions=[i for i, ft in enumerate(feature_names)
                   if ('DEM' in ft or 'biome' in ft)
                   and pattern in ft and '-ts' not in ft]
    )

    return sensorconfig


def get_sensor_config_timeseries(feature_names):
    all_sensors = [x.split('-')[0] for x in feature_names if '-ts' in x]
    unique_sensors = list(set(all_sensors))

    sensorconfig = {}
    for sensor in unique_sensors:
        allsensorfts = [x for x in feature_names if sensor in x if '-ts' in x]
        sensorchannels = list(set([x.split('-')[1] for x in allsensorfts]))
        sensorconfig[sensor] = {'channels': sensorchannels}

        for channel in sensorchannels:
            channelts = [ft for ft in allsensorfts if channel in ft]
            tsteps = sorted([int(ft.split('-')[2][2:]) for ft in channelts])
            positions = []
            for tstep in tsteps:
                positions += [i for i, ft in enumerate(feature_names)
                              if sensor in ft and channel
                              in ft and f'-ts{tstep}-' in ft]

            sensorconfig[sensor][channel] = dict(
                positions=positions
            )

    return sensorconfig
