from satio.features import (percentile_iqr, std, tsteps,
                            kurto, skewness, summation)
from worldcereal.utils.masking import SCL_MASK_VALUES
from worldcereal.features.feat_sen2agri import sen2agri_temp_feat
from worldcereal.features.settings import (get_default_rsi_meta,
                                           get_comp_mode_dict,
                                           get_default_ignore_def_feat)


def get_croptype_catboost_settings():
    return {
        'OPTICAL':
            {
                'bands': ["B02", "B03", "B04", "B05",
                          "B07", "B08", "B11", "B12"],
                'rsis': ["ndvi", "anir",
                         "ndmi", "ndre2",
                         "ndre1", "ndre5", "ndwi",
                         "ndgi", "evi", "brightness"],
                'composite': {
                    'freq': 10,
                    'window': 20,
                    'start': None,
                    'end': None},
                'mask': {
                    'erode_r': 3,
                    'dilate_r': 13,
                    'mask_values': SCL_MASK_VALUES,
                    'multitemporal': True},
                'seasons': {'rsi': 'evi',
                            'amp_thr1': 0.15,
                            'amp_thr2': 0.35,
                            'max_window': 250,
                            'partial': True}
                },
        'SAR':
            {
                'bands': ['VV', 'VH'],
                'rsis': ['vh_vv'],
                'composite': {
                    'freq': 12,
                    'window': 18,
                    'mode': 'mean',
                    'start': None,
                    'end': None},
                'mask': {
                    'METEOcol': '',
                    'precipitation_threshold': 10}
            },
        'METEO':
            {
                'bands': ['temperature_mean', 'precipitation_flux'],
                'composite': {
                    'freq': 1,  # Beware: changing this can have unexpected results for precipitation!  # NOQA
                    'window': 1,
                    'mode': get_comp_mode_dict(),
                    'start': None,
                    'end': None}
            }
    }


def get_croptype_catboost_features_meta():
    return {
        'OPTICAL':
            {
                "std": {
                    "function": std,
                    "names": ['std']},
                "skew": {
                    "function": skewness,
                    "names": ['skew'],
                    "bands": ['ndvi', 'ndmi',
                              'ndre2', 'ndre5']},
                "kurt": {
                    "function": kurto,
                    "names": ['kurt'],
                    "bands": ['ndvi', 'ndmi',
                              'ndre2', 'ndre5']},
                "sen2agri_temp_feat": {
                    "function": sen2agri_temp_feat,
                    "parameters": {
                        'time_start': None,
                        'time_freq': 10,
                        'w': 2,
                        'delta': 0.05,
                        'tsoil': 0.2},
                    "bands": ['ndvi'],
                    "names": ['maxdif', 'mindif', 'difminmax',
                              'peak', 'lengthpeak', 'areapeak',
                              'ascarea', 'asclength', 'ascratio',
                              'descarea', 'desclength',
                              'descratio', 'soil1', 'soil2']},
                "pheno_mult_season": {},
            },
        'SAR':
            {
                "std": {
                    "function": std,
                    "names": ['std']},
            },
        'METEO':
            {
                "sum": {
                    "function": summation,
                    "names": ['sum'],
                    "bands": ['precipitation_flux']},
                "percentile_iqr": {
                    "function": percentile_iqr,
                    "parameters": {'q': [10, 50, 90],
                                   'iqr': [25, 75]},
                    "names": ['p10', 'p50', 'p90', 'iqr'],
                    "bands": ['temperature_mean']}
            }
    }


def get_croptype_catboost_parameters():
    return {
        'settings': get_croptype_catboost_settings(),
        'features_meta': get_croptype_catboost_features_meta(),
        'rsi_meta': get_default_rsi_meta(),
        'ignore_def_feat': get_default_ignore_def_feat(),
        'gddnormalization': False}


#  TSTEP settings

def get_croptype_tsteps_parameters():
    return {
        'settings': get_croptype_tsteps_settings(),
        'features_meta': get_croptype_tsteps_features_meta(),
        'rsi_meta': get_default_rsi_meta(),
        'ignore_def_feat': {
            'OPTICAL': True,
            'SAR': True,
            'METEO': True
        },
        'gddnormalization': False
    }


def get_croptype_tsteps_settings():
    return {
        'OPTICAL':
        {
            'bands': ["B02", "B03", "B04", "B05",
                      "B06", "B07", "B08", "B11", "B12"],
            # 'rsis': ["evi"],
            'composite': {
                'freq': 10,
                'window': 20,
                'start': None,
                'end': None},
            'mask': {
                'erode_r': 3,
                'dilate_r': 13,
                'mask_values': SCL_MASK_VALUES,
                'multitemporal': True},
            # 'seasons': {'rsi': 'evi',
            #             'amp_thr1': 0.15,
            #             'amp_thr2': 0.35,
            #             'max_window': 250,
            #             'partial': True}
        },
        'SAR':
        {
            'bands': ['VV', 'VH'],
            'rsis': [],
            'composite': {
                'freq': 12,
                'window': 18,
                'mode': 'mean',
                'start': None,
                'end': None},
        },
        'METEO':
        {
            'bands': [
                'temperature_mean'
            ],
            'composite': {
                'freq': 30,
                'window': 30,
                'mode': get_comp_mode_dict(),
                'start': None,
                'end': None}
        }
    }


def get_croptype_tsteps_features_meta():
    return {
        'OPTICAL':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': 18,
                },
                "names": [f'ts{i}' for i in range(18)]
            },
        },
        'SAR':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': 18,
                },
                "names": [f'ts{i}' for i in range(18)]
            }
        },
        'METEO':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': 6,
                },
                "names": [f'ts{i}' for i in range(6)],
                "bands": ['temperature_mean']
            }
        }
    }
