from cropclass.features import (tsteps, to_db, to_pwr,
                                divide_10000, divide_100)
import numpy as np

N_STEPS = 18


def get_preprocessing_settings():
    return {
        'S2':
            {
                'dtype': np.float32,
                'pre_func': divide_10000,
                'bands': ["B02", "B03", "B04", "B05", "B06",
                          "B07", "B08", "B11", "B12"],
                'composite': {
                    'freq': 10,
                    'start': None,
                    'end': None
                },
                'interpolate': True
            },
        'S1':
            {
                'dtype': np.float32,
                'bands': ['VV', 'VH'],
                'pre_func': to_pwr,
                'post_func': to_db,
                'composite': {
                    'freq': 10,
                    'mode': 'mean',
                    'start': None,
                    'end': None
                },
                'interpolate': True
            },
        'METEO':
            {
                'dtype': np.float32,
                'pre_func': divide_100,
                'bands': ['temperature-mean'],
                'composite': {
                    'freq': 10,
                    'mode': 'mean',
                    'start': None,
                    'end': None
                },
                'interpolate': False  # Should not be needed
            },
    }


def get_feature_settings(n_tsteps=None):

    n_tsteps = n_tsteps if n_tsteps is not None else N_STEPS

    return {
        'S2':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': n_tsteps,
                },
                "names": [f'ts{i}' for i in range(n_tsteps)]
            },
        },
        'S1':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': n_tsteps,
                },
                "names": [f'ts{i}' for i in range(n_tsteps)]
            }
        },
        'METEO':
        {
            "tsteps": {
                "function": tsteps,
                "parameters": {
                    'n_steps': n_tsteps,
                },
                "names": [f'ts{i}' for i in range(n_tsteps)]
            }
        }
    }
