#!/usr/bin/env python3

from ._version import __version__
import pandas as pd

__all__ = ['__version__']


# LUT_CT = {
#     # [ewoc L0, ewoc L1, ewoc L2, CUSTOM CLASS]
#     1100: [1000, 1100, 0, 1100],     # Wheat
#     1110: [1000, 1100, 1110, 1100],  # Wheat
#     1120: [1000, 1100, 1120, 1100],  # Wheat
#     1200: [1000, 1200, 1200, 1200],  # Maize
#     1300: [1000, 1300, 1300, 1300],  # Rice
#     1400: [1000, 1400, 1400, 1400],  # Sorghum
#     1500: [1000, 1500, 0, 1500],     # Barley
#     1510: [1000, 1500, 1510, 1500],  # Barley
#     1520: [1000, 1500, 1520, 1500],  # Barley
#     1600: [1000, 1600, 0, 1600],     # Rye
#     1610: [1000, 1600, 1610, 1600],  # Rye
#     1620: [1000, 1600, 1620, 1600],  # Rye
#     1700: [1000, 1700, 1700, 1700],  # Oats
#     # 1800: [1000, 1800, 1800, 1800],  # Millets

#     2100: [2000, 2100, 0, 2000],     # Vegetables & melons
#     2110: [2000, 2100, 2110, 2000],  # Vegetables & melons
#     2120: [2000, 2100, 2120, 2000],  # Vegetables & melons
#     2130: [2000, 2100, 2130, 2000],  # Vegetables & melons
#     2140: [2000, 2100, 2140, 2000],  # Vegetables & melons
#     2150: [2000, 2100, 2150, 2000],  # Vegetables & melons
#     2160: [2000, 2100, 2160, 2000],  # Vegetables & melons
#     2170: [2000, 2100, 2170, 2000],  # Vegetables & melons
#     2200: [2000, 2200, 0, 2000],     # Vegetables & melons
#     2210: [2000, 2200, 2210, 2000],  # Vegetables & melons
#     2220: [2000, 2200, 2220, 2000],  # Vegetables & melons

#     2240: [2000, 2200, 2240, 2000],  # Vegetables & melons
#     2250: [2000, 2200, 2250, 2000],  # Vegetables & melons
#     2260: [2000, 2200, 2260, 2000],  # Vegetables & melons
#     2290: [2000, 2200, 2290, 2000],  # Vegetables & melons
#     2300: [2000, 2300, 0, 2000],     # Vegetables & melons
#     2310: [2000, 2300, 2310, 2000],  # Vegetables & melons
#     2320: [2000, 2300, 2320, 2000],  # Vegetables & melons
#     2330: [2000, 2300, 2330, 2000],  # Vegetables & melons
#     2340: [2000, 2300, 2340, 2000],  # Vegetables & melons
#     2350: [2000, 2300, 2350, 2000],  # Vegetables & melons
#     2400: [2000, 2400, 2400, 2000],  # Vegetables & melons

#     3000: [3000, 0, 0, 3000],        # Fruits & nuts
#     3100: [3000, 3100, 0, 3000],     # Fruits & nuts
#     3110: [3000, 3100, 3110, 3000],  # Fruits & nuts
#     3120: [3000, 3100, 3120, 3000],  # Fruits & nuts
#     3130: [3000, 3100, 3130, 3000],  # Fruits & nuts
#     3140: [3000, 3100, 3140, 3000],  # Fruits & nuts
#     3150: [3000, 3100, 3150, 3000],  # Fruits & nuts
#     3160: [3000, 3100, 3160, 3000],  # Fruits & nuts
#     3170: [3000, 3100, 3170, 3000],  # Fruits & nuts
#     3190: [3000, 3100, 3190, 3000],  # Fruits & nuts
#     3200: [3000, 3200, 0, 3000],     # Fruits & nuts
#     3210: [3000, 3200, 3210, 3000],  # Fruits & nuts
#     3220: [3000, 3200, 3220, 3000],  # Fruits & nuts
#     3230: [3000, 3200, 3230, 3000],  # Fruits & nuts
#     3240: [3000, 3200, 3240, 3000],  # Fruits & nuts
#     3290: [3000, 3200, 3290, 3000],  # Fruits & nuts
#     3300: [3000, 3300, 3300, 3300],  # Grapes
#     3400: [3000, 3400, 0, 3000],     # Fruits & nuts
#     3410: [3000, 3400, 3410, 3000],  # Fruits & nuts
#     3420: [3000, 3400, 3420, 3000],  # Fruits & nuts
#     3430: [3000, 3400, 3430, 3000],  # Fruits & nuts
#     3440: [3000, 3400, 3440, 3000],  # Fruits & nuts
#     3450: [3000, 3400, 3450, 3000],  # Fruits & nuts
#     3460: [3000, 3400, 3460, 3000],  # Fruits & nuts
#     3490: [3000, 3400, 3490, 3000],  # Fruits & nuts
#     3500: [3000, 3500, 0, 3000],     # Fruits & nuts
#     3510: [3000, 3500, 3510, 3000],  # Fruits & nuts
#     3520: [3000, 3500, 3520, 3000],  # Fruits & nuts
#     3530: [3000, 3500, 3530, 3000],  # Fruits & nuts
#     3540: [3000, 3500, 3540, 3000],  # Fruits & nuts
#     3550: [3000, 3500, 3550, 3000],  # Fruits & nuts
#     3560: [3000, 3500, 3560, 3000],  # Fruits & nuts
#     3590: [3000, 3500, 3590, 3000],  # Fruits & nuts
#     3600: [3000, 3600, 0, 3000],     # Fruits & nuts
#     3610: [3000, 3600, 3610, 3000],  # Fruits & nuts
#     3620: [3000, 3600, 3620, 3000],  # Fruits & nuts
#     3630: [3000, 3600, 3630, 3000],  # Fruits & nuts
#     3640: [3000, 3600, 3640, 3000],  # Fruits & nuts
#     3650: [3000, 3600, 3650, 3000],  # Fruits & nuts
#     3660: [3000, 3600, 3660, 3000],  # Fruits & nuts
#     3690: [3000, 3600, 3690, 3000],  # Fruits & nuts
#     3900: [3000, 3900, 3900, 3000],  # Fruits & nuts
#     4100: [4000, 4100, 4100, 4100],  # Soybean
#     4200: [4000, 4200, 4200, 4200],  # Ground nut
#     4350: [4000, 4300, 4350, 4350],  # Rapeseed
#     4351: [4000, 4300, 4350, 4350],  # Rapeseed
#     4352: [4000, 4300, 4350, 4350],  # Rapeseed
#     4380: [4000, 4300, 4380, 4380],  # Sunflower
#     4420: [4000, 4400, 4420, 4420],  # Olives
#     5100: [5000, 5100, 5100, 5100],  # Potato
#     7100: [7000, 7100, 7100, 7100],  # Beans
#     7200: [7000, 7200, 7200, 7100],  # Beans
#     7300: [7000, 7300, 7300, 7300],  # Peas
#     7400: [7000, 7400, 7400, 7300],  # Peas
#     7700: [7000, 7700, 7700, 7300],  # Peas
#     7800: [7000, 7800, 7800, 7300],  # Peas
#     8100: [8000, 8100, 8100, 8100],  # Sugar beet
#     9100: [9000, 9100, 0, 13],     # Grass
#     9110: [9000, 9100, 9110, 13],  # Grass
#     9120: [9000, 9100, 9120, 13],  # Grass
#     9200: [9000, 9200, 0, 13],     # Fibre crops
#     9210: [9000, 9200, 9210, 13],  # Fibre crops
#     9211: [9000, 9200, 9211, 13],  # Fibre crops
#     9212: [9000, 9200, 9212, 13],  # Fibre crops
#     9213: [9000, 9200, 9213, 13],  # Fibre crops
#     9219: [9000, 9200, 9219, 13],  # Fibre crops
# }

LUT_CT = {

    1200: 1200,  # Maize
    9120: 0,  # Grass
    9100: 0,     #
    9110: 0,  # Grass
    1110: 1100,  # Wheat
    1120: 1100,  # Wheat
    1100: 1100,  # Wheat
    4100: 4100,  # Soybean
    1500: 1500,  # Barley
    1510: 1500,  # Barley
    1520: 1500,  # Barley
    4380: 4380,  # Sunflower
    4420: 0,  # Olives
    1300: 1300,  # Rice
    9210: 9210,  # Temporary fibre crops
    9211: 9210,  # Cotton: Temporary fibre crops
    9212: 9210,  # Jute: Temporary fibre crops
    9213: 9210,  # Flax: Temporary fibre crops
    3300: 0,  # Grapes
    5100: 5100,  # Potato
    1400: 0,  # Sorghum
    4330: 4350,  # Rapeseed / Mustard
    1700: 1700,  # Oats
    8100: 8100,  # Sugar beet
    4350: 4350,  # Rapeseed / Mustard
    4351: 4350,  # Rapeseed / Mustard
    4352: 4350,  # Rapeseed / Mustard
    1600: 1600,  # Rye
    1610: 1600,  # Rye
    1620: 1600,  # Rye
    4200: 0,  # Ground nut
    1800: 0,  # Millets
    5300: 0,  # Cassava

    2310: 2000,  # Vegetables
    2900: 2000,  # Vegetables
    2130: 2000,  # Vegetables
    2140: 2000,  # Vegetables
    2350: 2000,  # Vegetables
    2340: 2000,  # Vegetables
    2170: 2000,  # Vegetables
    2190: 2000,  # Vegetables

    5200: 0,  # Vegetables

    7700: 2000,  # Peas
    7400: 2000,  # Peas
    7300: 2000,  # Peas

    7100: 2000,  # Beans
    7200: 2000,  # Beans

    3510: 0,  # Fruit trees
    3520: 0,  # Fruit trees
    3530: 0,  # Fruit trees
    3540: 0,  # Fruit trees
    3550: 0,  # Fruit trees
    3560: 0,  # Fruit trees
    3590: 0,  # Fruit trees
    3210: 0,  # Fruit trees
    3220: 0,  # Fruit trees
    3230: 0,  # Fruit trees
    3240: 0,  # Fruit trees
    3120: 0,  # Fruit trees
    3170: 0,  # Fruit trees
    3190: 0,  # Fruit trees

    3600: 0,  # Nuts
    3610: 0,  # Nuts
    3620: 0,  # Nuts
    3630: 0,  # Nuts
    3640: 0,  # Nuts
    3650: 0,  # Nuts
    3660: 0,  # Nuts
    3690: 0,  # Nuts

}

LUT_LC = {

    11: 11,
    12: 30,
    13: 13,
    20: 13,
    30: 30,
    40: 30,
    41: 30,
    42: 30,
    50: 60,
    60: 60,
    70: 70,
    80: 70

}


def get_lut_ct():
    return pd.DataFrame.from_dict(
        LUT_CT, orient='index',
        columns=['CUSTOM'])


def get_lut_lc():
    return pd.DataFrame.from_dict(
        LUT_LC, orient='index',
        columns=['CUSTOM'])


def get_ct_classes():
    lut = get_lut_ct()
    unique_classes = list(lut['CUSTOM'].unique())
    # if 0 in unique_classes:
    #     unique_classes.pop(0)
    return unique_classes


def get_lc_classes():
    lut = get_lut_lc()
    unique_classes = list(lut['CUSTOM'].unique())
    # if 0 in unique_classes:
    #     unique_classes.pop(0)
    return unique_classes
