"""Model constants."""

from __future__ import annotations

from functools import lru_cache
from pathlib import Path

BIOME_TAG = "biome"
DEM_TAG = "DEM"
METEO_TAG = "METEO"
S1_TAG = "S1"
S2_TAG = "S2"


@lru_cache
def get_root_folder() -> Path:
    """Load in the root folder."""
    folder = Path.home() / "Private/vito-crop-classification/"
    folder.mkdir(exist_ok=True, parents=True)
    return folder


@lru_cache
def get_data_folder() -> Path:
    """Load in the data folder."""
    folder = get_root_folder() / "data"
    folder.mkdir(exist_ok=True, parents=True)
    return folder


@lru_cache
def get_models_folder() -> Path:
    """Load in the model folder."""
    folder = get_root_folder() / "models"
    folder.mkdir(exist_ok=True, parents=True)
    return folder


@lru_cache
def get_filters_folder() -> Path:
    """Load in the filter folder."""
    folder = get_root_folder() / "filters"
    folder.mkdir(exist_ok=True, parents=True)
    return folder


@lru_cache
def get_configs_folder() -> Path:
    """Load in the config folder."""
    folder = Path(__file__).parent / "configs"
    folder.mkdir(exist_ok=True, parents=True)
    return folder
