from typing import Dict

def get_tile_extent(tile_id: str) -> Dict:
    from satio import layers
    
    s2grid = layers.load('s2grid')
    s2bounds = s2grid.set_index('tile').loc[tile_id].geometry.bounds
    extent = dict(zip(["west", "south", "east", "north"], s2bounds))
    extent['crs'] = "EPSG:4326"
    
    return extent

def get_tile_extent_laea(tile_id: str) -> Dict:
    import geopandas as gpd

    # TODO find something to manage this path better
    # Get a file with already projected bounds
    laea_df = gpd.read_file('/vitodata/EEA_HRL_VLCC/data/ref/20km_test_tiles/reference_LAEA/LAEA-20km.gpkg').to_crs('EPSG:3035')
    tile_bounds = laea_df.set_index('name').loc[tile_id].geometry.bounds
    extent = dict(zip(["west", "south", "east", "north"], tile_bounds))
    extent['crs'] = 3035

    return extent
