#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Aug  3 11:19:07 2022

@author: bertelsl
"""
import os
import numpy as np
import xarray as xr
import pandas as pd
import netCDF4

fIn = r'/data/EEA_HRL_VLCC/data/ref/lucas/LUCAS2018/2018_EU_LUCAS2018_POINT_JD/Lucas group_[621649580795035646, 621650681052430334).json/timeseries.nc'
fOutdir = r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/'

data = xr.load_dataset(fIn)

'''
The dataset has no entries for all dates 2017/09/01 till 2019/03/31. Fill the missing dates with nan.
'''
# 2017/09/01 till 2019/03/31
period = 577
newT = pd.date_range("2017-09-01", periods=period)

# get available dates for the actual data
# at_date= data['t'].values
file2read = netCDF4.Dataset(fIn,'r')
at_date = file2read.variables['t'][:]
at_date = np.ma.getdata(at_date)

# get S2 data
aB02 = data['B02'].values

aVH = data['VH'].values

# get empty 2D array for the complete period
aBand = np.zeros(shape=(np.shape(aB02)[0], period))
aBand[:] = np.nan

aBand[:, at_date] = aB02

# get coordinates
lat = data['lat'].values
lon = data['lon'].values

# create the new dataset
new_data = xr.Dataset(
        data_vars=dict(
            B02=(["feature", "date"], aBand),
        ),
        coords=dict(
            date=(newT),
            lon=(["feature"], lon),
            lat=(["feature"], lat),
        ),
        attrs=dict(description="JFdist applied on full date range data."),
    )

# save the new dataset
fOut = os.path.join(fOutdir, 'test.nc')
new_data.to_netcdf(fOut)

datatest = xr.load_dataset(fOut)
aTest = datatest['B02'].values








