#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Aug 19 08:27:05 2022

@author: bertelsl
"""
import os
import glob
import netCDF4
import json
import xarray as xr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import warnings
from datetime import datetime

fS1_LPIS = '/data/EEA_HRL_VLCC/data/ref/crop_type/2018_AT_LPIS_POLY_110/TS/S1_2017-09-01_2018-08-30_2018_AT_LPIS_POLY_110.nc'
fS2_LPIS = '/data/EEA_HRL_VLCC/data/ref/crop_type/2018_AT_LPIS_POLY_110/TS/S2_2017-09-01_2018-08-30_2018_AT_LPIS_POLY_110.nc'
fS12_LPIS = '/data/EEA_HRL_VLCC/data/ref/crop_type/2018_AT_LPIS_POLY_110/2018_AT_LPIS_POLY_110_2017-09-01_2018-08-30_InputsOutputs_crops.nc'

fS1_LUCAS = '/data/EEA_HRL_VLCC/data/ref/lucas/LUCAS2018/LUCAS2018_CREO_BACKSCATTER/Lucas group_[621646289278631934, 621646835588923390).json creodias/timeseries.nc'
fS2_LUCAS = '/data/EEA_HRL_VLCC/data/ref/lucas/LUCAS2018/LUCAS2018_SHUB/Lucas group_[621649032028913662, 621649580795035646).json/timeseries.nc'


xS1_LPIS =  xr.open_dataset(fS1_LPIS)
xS2_LPIS =  xr.open_dataset(fS2_LPIS)
xS12_LPIS =  xr.open_dataset(fS12_LPIS)

xS1_LUCAS = xr.open_dataset(fS1_LUCAS)
xS2_LUCAS = xr.open_dataset(fS2_LUCAS)

aVH_LPIS = xS1_LPIS['VH'].values   # float vb. 0.0487637
aB04_LPIS = xS2_LPIS['B04'].values # float vb. 0.0466848 * 1/0.0001

aVH_LUCAS = xS1_LUCAS['VH'].values # int vb. -18.2839
aB04_LUCAS = xS2_LUCAS['B04'].values # int vb. 447

