#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Aug  5 13:25:52 2022

@author: bertelsl
"""

import os
import glob
import netCDF4
import json
import xarray as xr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

fIn = r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/4_HANTS_matrices/Barley_RMSE_MX.nc'

xMX = xr.load_dataset(fIn)    

'''
<xarray.Dataset>
Dimensions:  (labels: 1229, labelsX: 1229, labelsY: 16905)
Coordinates:
  * labelsY  (labelsY) object 'Barley' 'Barley' ... 'Vineyards' 'Vineyards'
  * labelsX  (labelsX) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    ids      (labels) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    lat      (labelsX) float64 56.34 56.34 56.33 56.4 ... 53.52 53.59 53.97
    lon      (labelsX) float64 21.28 21.54 21.64 21.5 ... 53.52 53.59 53.97
Dimensions without coordinates: labels
Data variables:
    MX       (labelsX, labelsY) float32 nan 0.21122496 ... 0.3896158 0.3658464
Attributes:
    description:  matrix
---------------------------------------------------------------------------------------------------------------------------------'''

xCrop = xMX.where((xMX.labelsY  == 'Barley'), drop=True)
aLabelsX = xCrop['labelsX'].values
'''
<xarray.Dataset>
Dimensions:  (labels: 1229, labelsX: 1229, labelsY: 1229)
Coordinates:
  * labelsY  (labelsY) object 'Barley' 'Barley' 'Barley' ... 'Barley' 'Barley'
  * labelsX  (labelsX) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    ids      (labels) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    lat      (labelsX) float64 56.34 56.34 56.33 56.4 ... 53.52 53.59 53.97
    lon      (labelsX) float64 21.28 21.54 21.64 21.5 ... 53.52 53.59 53.97
Dimensions without coordinates: labels
Data variables:
    MX       (labelsX, labelsY) float32 nan 0.21122496 ... 0.2948197 nan
Attributes:
    description:  matrix
---------------------------------------------------------------------------------------------------------------------------------'''

xCrop['labelsY'] = aLabelsX
aCrop = xCrop['MX'].values
'''
<xarray.Dataset>
Dimensions:  (labels: 1229, labelsX: 1229, labelsY: 1229)
Coordinates:
  * labelsY  (labelsY) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
  * labelsX  (labelsX) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    ids      (labels) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    lat      (labelsX) float64 56.34 56.34 56.33 56.4 ... 53.52 53.59 53.97
    lon      (labelsX) float64 21.28 21.54 21.64 21.5 ... 53.52 53.59 53.97
Dimensions without coordinates: labels
Data variables:
    MX       (labelsX, labelsY) float32 nan 0.21122496 ... 0.2948197 nan
Attributes:
    description:  matrix
---------------------------------------------------------------------------------------------------------------------------------'''

xOther = xMX.where((xMX.labelsY  != 'Barley'), drop=True)
'''
<xarray.Dataset>
Dimensions:  (labels: 1229, labelsX: 1229, labelsY: 15676)
Coordinates:
  * labelsY  (labelsY) object 'Common_wheat' 'Common_wheat' ... 'Vineyards'
  * labelsX  (labelsX) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    ids      (labels) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    lat      (labelsX) float64 56.34 56.34 56.33 56.4 ... 53.52 53.59 53.97
    lon      (labelsX) float64 21.28 21.54 21.64 21.5 ... 53.52 53.59 53.97
Dimensions without coordinates: labels
Data variables:
    MX       (labelsX, labelsY) float32 0.27740088 0.15989117 ... 0.3658464
Attributes:
    description:  matrix
---------------------------------------------------------------------------------------------------------------------------------'''


aLabelsY = xOther['labelsY'].values

current_label = aLabelsY[0]
count = 1
aNewLabels = []

for label in aLabelsY:
    if label != current_label:
        count = 1
        current_label = label
    aNewLabels.append('{}_{}'.format(label, count))
    count+=1
    
xOther['labelsY'] = aNewLabels
'''
<xarray.Dataset>
Dimensions:  (labels: 1229, labelsX: 1229, labelsY: 15676)
Coordinates:
  * labelsY  (labelsY) <U39 'Common_wheat_1' ... 'Vineyards_142'
  * labelsX  (labelsX) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    ids      (labels) object 'Barley_1' 'Barley_2' ... 'Barley_1229'
    lat      (labelsX) float64 56.34 56.34 56.33 56.4 ... 53.52 53.59 53.97
    lon      (labelsX) float64 21.28 21.54 21.64 21.5 ... 53.52 53.59 53.97
Dimensions without coordinates: labels
Data variables:
    MX       (labelsX, labelsY) float32 0.27740088 0.15989117 ... 0.3658464
Attributes:
    description:  matrix
---------------------------------------------------------------------------------------------------------------------------------'''

drops = ['Barley_1', 'Barley_3']
for aaa in drops:
    xCrop = xCrop.where(xCrop.labelsX != aaa, drop=True)
    xCrop = xCrop.where(xCrop.labelsY != aaa, drop=True)
aCrop2 = xCrop['MX'].values
'''
ValueError: shape mismatch: objects cannot be broadcast to a single shape
'''











