# -*- coding: utf-8 -*-
"""
Created on Fri Jul 15 07:52:21 2022

@author: bertelsl
"""
import netCDF4
import numpy as np
import matplotlib.pyplot as plt
import xarray as xr


fIn = r'/data/EEA_HRL_VLCC/data/ref/crop_type/2018_BE_LPIS-Flanders_POLY_110/2018_BE_LPIS-Flanders_POLY_110_2017-09-01_2018-08-30_InputsOutputs_crops.nc'

fID = r'/data/EEA_HRL_VLCC/data/ref/crop_type/2018_AT_LPIS_POLY_110/TS/S1_2017-09-01_2018-08-30_2018_AT_LPIS_POLY_110.nc'


xInput = xr.open_dataset(fIn) 

xID = xr.open_dataset(fID)


file2read = netCDF4.Dataset(fIn,'r')

print(file2read.variables.keys())

AA = file2read.variables['time'][:]
aAA = np.ma.getdata(AA)

print(aAA)


B02 = file2read.variables['B02'][:]
aB02 = np.ma.getdata(B02)

SCL = file2read.variables['SCL'][:]
aSCL = np.ma.getdata(SCL)

aSCL = np.round(aSCL * 10000)

# code = file2read.variables['LABEL'][:]
CODE_OBJ = file2read.variables['CODE_OBJ'][:]
print(CODE_OBJ)

aB02[np.isnan(aB02)] = 0

x = aB02[:, 0]
y = np.arange(364)

plt.plot(y,x)
plt.show()
a=1

