#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Aug  3 09:46:07 2022

@author: bertelsl
"""
import os
import glob
import netCDF4
import json
import numpy as np
import pandas as pd

fBasedir = r'/data/EEA_HRL_VLCC/data/ref/lucas/LUCAS2018/2018_EU_LUCAS2018_POINT_JD/'
fSplitdir = r'/data/EEA_HRL_VLCC/data/ref/lucas/LUCAS2018/2018_EU_LUCAS2018_POINT_JD/lucas_split/'
fOutdir = r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/'

aInDirs = glob.glob(fBasedir+'Lucas *')
aSplit = glob.glob(os.path.join(fSplitdir, '*.json'))
Nr = 1

aLabels = []
    
for fSubdir in aInDirs:
    # check if outputfile is alreay there
    
    basename = os.path.basename(fSubdir).split('.')[0]
    fOut = os.path.join(fOutdir, basename+'.csv')    

    print('Processing: {} - {}'.format(Nr, basename))
    Nr += 1
       
    if os.path.isfile(fOut):
        continue 
    
    fTimeseries = os.path.join(fSubdir, 'timeseries.nc')
    fInfo = glob.glob(os.path.join(fSubdir, 'group_*.json'))
    
    if len(fInfo) == 0:
        fInfo = [s for s in aSplit if (basename.split(' ')[1] in s)][0]
    else:
        fInfo = fInfo[0]
    
    if not os.path.isfile(fTimeseries):
        print('*** ERROR: file not found: {}'.format(fTimeseries))
        
    if not os.path.isfile(fInfo):
        print('*** ERROR: file not found: {}'.format(fInfo))
    
    data = json.load(open(fInfo))
    aFeatures = data["features"]

    # aLabels = []

    for feature in aFeatures:
        aLabels.append(feature['properties']['LC1_LABEL'])





for label in np.unique(aLabels):
    print(label)


a=1









