#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Aug 19 08:27:05 2022

@author: bertelsl
"""
import os
import glob
import netCDF4
import json
import xarray as xr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import warnings
from datetime import datetime

# fIn = '/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/10_cross_validate_full/Scores_accuracy_mean.csv'
# fIn = '/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/10_cross_validate_min_outliers/Scores_accuracy_mean.csv'
fIn ='/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/10_cross_validate_min_outliers_bf032/Scores_accuracy_mean.csv'
df = pd.read_csv(fIn, sep=';', index_col=False)
df.drop('Unnamed: 0', axis=1, inplace=True)
df.drop('crop types', axis=1, inplace=True)
df.drop('nEntries', axis=1, inplace=True)
aData = np.array(df)
aData = aData[aData != 0]

nTot = len(aData)
n80 = np.sum(aData >= 0.80)
n90 = np.sum(aData >= 0.90)
n95 = np.sum(aData >= 0.95)

p80 = np.round(n80/nTot * 100)
p90 = np.round(n90/nTot * 100)
p95 = np.round(n95/nTot * 100)

hist1, bin_edges1 = np.histogram(aData, bins=50, range=[0 , 1])

fig, ax = plt.subplots()

ax.grid(b=True, color='grey', linestyle='-', linewidth=0.5, alpha=0.6)

# _ = ax.bar(bin_edges1[:-1], hist1, width=np.diff(bin_edges1), label='Scores_accuracy_full')
# _ = ax.bar(bin_edges1[:-1], hist1, width=np.diff(bin_edges1), label='Scores_accuracy_min_outliers')
_ = ax.bar(bin_edges1[:-1], hist1, width=np.diff(bin_edges1), label='Scores_accuracy_min_outliers_bf032')

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel('Scores')

ax.text (0, 40,  'n > 80: {} / {} = {} %'.format(n80, nTot, p80), transform=ax.transData)
ax.text (0, 35,  'n > 90: {} / {} = {} %'.format(n90, nTot, p90), transform=ax.transData)
ax.text (0, 30,  'n > 95: {} / {} = {} %'.format(n95, nTot, p95), transform=ax.transData)

# ax.set_xticks(x, labels)
ax.legend()
fig.tight_layout()

# plt.savefig(fOut)
# plt.close()
plt.show()

