#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Aug 24 09:46:26 2022

@author: bertelsl

Algorithm:
    
    - group the pre-processed data per crop type:
        
        'fIndir': r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/01_LUCAS_preprocessed/',        
        'fOutdir': r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/03_satio_crops/',
        
Version: 31/08/2022

"""
import os
import glob
import netCDF4
import json
import xarray as xr
import numpy as np
import pandas as pd


#================================================================================================================
class cGroupLUCAS(object):
#================================================================================================================
    def __init__(self, Info):        
#================================================================================================================
        
        self.fIndir = Info['fIndir']
        self.fOutdir = Info['fOutdir']
        self.overwrite = Info['overwrite']
        
        if not os.path.isdir(self.fOutdir):
            os.mkdir(self.fOutdir)        
            
#================================================================================================================
    def start_processing(self):        
#================================================================================================================
        
        self.get_data('S1')
        self.group_crops('S1')
        
        self.get_data('S2')
        self.group_crops('S2')

#================================================================================================================
    def group_crops(self, forS):        
#================================================================================================================
        
        aCrops = self.aXinput['labels'].values
        aUnique_crops = np.unique(aCrops)
        
        for crop in aUnique_crops:

            fOut = os.path.join(self.fOutdir, '{}_{}.nc'.format(forS, crop.replace('/', '_')))
            
            if os.path.isfile(fOut):
                if self.overwrite:
                    os.remove(fOut)
                else:
                    continue

            print('\r * Writing data for {}'.format(crop), 
                  end='                                                                                                                                               ')
            
            xCrop = self.aXinput.where(self.aXinput['labels'] == crop, drop=True)
            xCrop.to_netcdf(fOut)
            
        print('')

#================================================================================================================
    def get_data(self, forS):        
#================================================================================================================
        
        afS = glob.glob(self.fIndir + '{}*.nc'.format(forS))
        
        count = 0
        
        for fS in afS:
            print('\r * Reading data {} / {} for {}'.format(count, len(afS)-1, os.path.basename(fS).split('.')[0]),
                  end='                                                                                                                                               ')

            xInput = xr.open_dataset(fS)
            
            if count == 0:
                self.aXinput = xInput
            else:
                self.aXinput = xr.concat([self.aXinput, xInput], dim='labels')

            count += 1

        print('')

#================================================================================================================
if __name__ == '__main__':
#================================================================================================================

    Info = {
        'fIndir': r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/01_LUCAS_preprocessed/',
        'fOutdir': r'/data/EEA_HRL_VLCC/user/luc/data/LUCAS2018/03_LUCAS_crops/',
        'overwrite': True
        }

    oGroupLUCAS = cGroupLUCAS(Info)
    oGroupLUCAS.start_processing()

