"""Utility functions for semantic segmentation models."""

from __future__ import annotations

from typing import Any

from vito_lot_delineation.models.base_model import BaseModel
from vito_lot_delineation.models.semantic.EnanchedResUnet3D import EnanchedResUnet3D
from vito_lot_delineation.models.semantic.ResUnet3D import ResUnet3D
from vito_lot_delineation.models.semantic.SMPModel import SMPModel


def parse_model(
    model_cfg: dict[str, Any],
) -> BaseModel:
    """Parse the activation function."""
    architecture = model_cfg["architecture"]
    if architecture.startswith("smp"):
        model_cfg["class"] = architecture.split(".")[1]
        return SMPModel(model_cfg)
    if architecture == "ResUnet3D":
        return ResUnet3D(**model_cfg["params"])
    if architecture == "EnanchedResUnet3D":
        return EnanchedResUnet3D(**model_cfg["params"])
    raise ValueError(f"Unknown architecture: {architecture}")
