"""Model constants."""

from __future__ import annotations

from functools import lru_cache
from pathlib import Path


@lru_cache
def get_data_folder() -> Path:
    """Get the data folder."""
    path = Path(__file__).parents[3] / "data"
    assert path.is_dir(), "Use DVC to pull data first!"
    return path


@lru_cache
def get_models_folder() -> Path:
    """Load in the model folder."""
    folder = get_data_folder() / "models"
    folder.mkdir(exist_ok=True, parents=True)
    return folder
