"""Base configuration files."""

from __future__ import annotations

import json
from pathlib import Path
from typing import Any


def get_cfg(cfg_tag: str = "base") -> dict[str, Any]:
    """Get model configuration file."""
    with open(Path(__file__).parent / f"{cfg_tag}.json") as f:
        res: dict[str, Any] = json.load(f)
    return res
