from pathlib import Path
import os
import re

class UDFString():
    
    def __init__(self, filename=None):
        self.udfs=[]
        self.fnames=[]
        self.load(filename)
        self.ws='    '
        self.header='# -*- coding: utf-8 -*-\n'+\
                    '# Uncomment the import only for coding support~\n'+\
                    'from openeo_udf.api.datacube import DataCube\n'+\
                    'from typing import Dict\n'+\
                    'def apply_datacube(cube: DataCube, context: Dict) -> DataCube:\n'
        self.footer='\n'+self.ws+'return cube\n'
        
    def load(self, filename):
        if filename is not None:
            with open(str(Path(filename)), 'r+') as f:
                self.udfs.append(f.read())
                self.fnames.append('apply_datacube_'+os.path.basename(Path(filename)).replace('.','_'))
        return self
    
    def replace_option(self,option,new_value):
        self.udfs=list(map(lambda iudf: re.sub('(\n\s*'+option+'\s*=).*\n','\\1 '+new_value+'\n',iudf,count=1), self.udfs))
        return self
    
    def _wrap(self):
        mangledudfs=[]
        for iudf in range(len(self.udfs)):
            # replacing 'apply_datacube' signature
            mangledudfs.append(
                self.ws+re.sub('\ndef\s*apply_datacube\s*\(','\ndef '+self.fnames[iudf]+'(',self.udfs[iudf],count=1).replace('\n','\n'+self.ws)+'\n'
            )
        return '\n'.join(mangledudfs)
    
    def prepare(self,wrap_single=False):
        # single udf: don't touch
        if len(self.udfs)==1 and not wrap_single: return self.udfs[0]
        # wrap and add the list of apply_cubes to be chained
        prepared_udf=self.header+self._wrap()+'\n'
        prepared_udf+='\n'.join(map(lambda icall: self.ws+'cube='+icall+'(cube,context)',self.fnames))
        return prepared_udf+self.footer             
