import json

def pg_save(filename:str, udpid:str, summary:str, description:str, pg:dict):
    c=pg.copy()
    c['id']= udpid
    c['summary']= summary
    c['description']= description
    c["process_graph"]=c["process_graph"].flat_graph()
    with open(filename,"w") as f: json.dump(c, f, indent=2)
        
def pg_load(filename:str):
    with open(filename) as f: pg=json.load(f)
    return pg
    
def pg_upload(eoconn, pg:dict):
    print('Parameters for: '+pg['id'])
    for i in pg['parameters']: print(i['name']+'='+json.dumps(i.get('default',''))+",")
    eoconn.save_user_defined_process(
        pg['id'], 
        process_graph=pg['process_graph'], 
        parameters=pg['parameters'], 
        public=False, 
        summary=pg['summary'], 
        description=pg['description']
    )

