from openeo.rest.datacube import THIS
from openeo_processes.utils.udfstring import UDFString
import os

def add_filtersmallpolygons_process(
        vpg: dict,
        area_threshold=0.05*10000
    ):

    vpg['process_graph'] = vpg['process_graph'].process("run_udf",{
        "data": THIS,
        "udf": UDFString(os.path.dirname(__file__)+'/../udf/filter_smallpolygons.py').prepare(),
        "runtime":"Python",
        "context": {
            "area_threshold": area_threshold
        }
    })
    
    return vpg