from openeo.api.process import Parameter
from openeo.rest.datacube import THIS
from openeo_processes.utils.udfstring import UDFString
import os

def add_centerpolygon_process(
        vpg: dict,
        area_threshold=0.05*10000,
        overlap_length=50.
    ):

    # selection in the middle
    parameters={
        'cpx': Parameter(
            name="centerpoint_x", description="Centerpoint X coordinate",
            schema="number"
        ),
        'cpy': Parameter(
            name="centerpoint_y", description="Centerpoint Y coordinate",
            schema="number"
        )
    }
    
    vpg['process_graph'] = vpg['process_graph'].process("run_udf",{
        "data": THIS,
        "udf": UDFString(os.path.dirname(__file__)+'/../udf/select_polygon.py').prepare(),
        "runtime":"Python",
        "context": {
            "centerpoint_x": {'from_parameter': 'centerpoint_x'},
            "centerpoint_y": {'from_parameter': 'centerpoint_y'},
            "area_threshold": area_threshold,
            "overlap_length": overlap_length
        }
    })
    
    vpg['parameters']+=[ i.to_dict() for i in parameters.values() ]
    
    return vpg