import numpy
import scipy.signal


def makekernel(size: int) -> numpy.ndarray:
    assert size % 2 == 1
    kernel_vect = scipy.signal.windows.gaussian(size, std=size / 6.0, sym=True)
    kernel = numpy.outer(kernel_vect, kernel_vect)
    kernel = kernel / kernel.sum()
    return kernel


def create_advanced_mask(band, startdate, enddate, band_math_workaround=True):
    # in openEO, 1 means mask (remove pixel) 0 means keep pixel
    scl=band
    # keep useful pixels, so set to 1 (remove) if smaller than threshold
    mask1a = ~((scl==2) | (scl==4) | (scl==5) | (scl==6) | (scl==7))
    mask1b = mask1a.apply_kernel(makekernel(17))
    #remove pixels smaller than threshold, so pixels with a lot of neighbouring good pixels are retained?
#     if band_math_workaround:
#         mask1b = mask1b.add_dimension("bands", "mask", type="bands").band("mask")
    mask1c = mask1b > 0.057

    # remove cloud pixels so set to 1 (remove) if larger than threshold
    mask2a = (scl==3) | (scl==8) | (scl==9) | (scl==10) | (scl==11)
    mask2b = mask2a.apply_kernel(makekernel(201))
#     if band_math_workaround:
#         mask2b = mask2b.add_dimension("bands", "mask", type="bands").band("mask")
    mask2c = mask2b > 0.025
 
    # TODO: the use of filter_temporal is a trick to make cube merging work, needs to be fixed in openeo client
    return mask1c.filter_temporal(startdate, enddate) | mask2c.filter_temporal(startdate, enddate)
    #return mask1c | mask2c
    #return first_mask | second_mask
    #return first_mask

