# -*- coding: utf-8 -*-
# Uncomment the import only for coding support
from openeo_udf.api.udf_data import UdfData


def udf(data: UdfData):

    import geopandas
    import pandas
    import shapely.geometry

#     from uuid import uuid4
#     import json
#     uid=str(uuid4().hex)
#     with open('/data/users/Public/banyait/selectpolygon_in_'+uid+'.json','w') as f:
#         json.dump(data.to_dict(),f,indent=2)

    # config from context
    centerpoint=[
        data.user_context['centerpoint_x'],
        data.user_context['centerpoint_y'],
    ]
    # TODO: these defaults for sentinel-2 (10m resolution) to be fine-tuned
    area_threshold=data.user_context.get('area_threshold',0.25*10000)
    buffer_size=data.user_context.get('buffer_size',1.)
    overlap_length=data.user_context.get('overlap_length',50.)
    
    # build projection and shapely point
    c= shapely.geometry.Point(centerpoint[0],centerpoint[1])#.buffer(10.,resolution=2)
    
    # build the polygon
    for ifeat in data.get_feature_collection_list():
        df=ifeat.get_data()
        df['value']=0.

        # filter small areas
        
        df=df[df.area>=area_threshold]

        # find the poly(s) containing the point
        dfcenter=df[df.touches(c)|df.contains(c)]
        if len(dfcenter)==0: 
            dfcenter.drop('value', axis=1, inplace=True)
            ifeat.set_data(dfcenter)
            continue
        if len(dfcenter)>1:
            dfcenter = dfcenter.dissolve(by='value',as_index=False)

#         from matplotlib import pyplot
#         bla=df
#         bla['idx']=df.index
#         ax=bla.plot(column=bla.idx)
            
        # iteratively grow until nothing new added
        for i in range(20):
            
            if len(df)==0: break
            centerpoly=dfcenter['geometry'].values[0].buffer(buffer_size,resolution=1)
    
            # separare polygons touching the center polygon and remove those from df
#            istouch=df.touches(centerpoly) | df.intersects(centerpoly) | df.overlaps(centerpoly)
            istouch=df.overlaps(centerpoly)
            dftouch=df[istouch]
            if len(dftouch)==0: break
            df=df[~istouch]
    
            # filter by minimum touch length
            # the length is approximately twice the overlap because of the buffer on the centerpoly
            dftouch['value']=dftouch.intersection(centerpoly).length
            dftouch=dftouch[dftouch['value']>=2*overlap_length] 
            
            # merge into center
            dftouch['value']=0.
            dfcenter=geopandas.GeoDataFrame( pandas.concat( [dfcenter,dftouch], ignore_index=True) )
            dfcenter = dfcenter.dissolve(by='value',as_index=False)
                  
#         dfcenter.plot(color='orange',ax=ax)
#         pyplot.plot(*c.xy,'ro')
#         pyplot.show()

                    
        # remove value and replace feature
        dfcenter.drop('value', axis=1, inplace=True)
        ifeat.set_data(dfcenter)     

    return data