# -*- coding: utf-8 -*-
# Uncomment the import only for coding support
from openeo_udf.api.datacube import DataCube
from typing import Dict


def apply_datacube(cube: DataCube, context: Dict) -> DataCube:

    from openeo.udf.xarraydatacube import XarrayDataCube
    #from openeo.rest.conversions import datacube_to_file
    import numpy
    import pathlib
    
    data=cube.get_array()

    # TODO: fail on numbands>1
    dump_location='./'
    tileID='99OOO'
    year=int(data.t.dt.year.max())
    maxnodata=0.05
    cropBounds=None 
    if context is not None:
        dump_location=context.get('dump_location',dump_location)
        tileID=context.get('tileID',tileID)
        year=int(context.get('year',year))
        maxnodata=float(context.get('maxnodata',maxnodata))
        cropBounds=context.get('cropBounds',cropBounds)


    # skip if cropbounds is set (xmin,ymin,xmax,ymax) and any portion of the cube is outside of the bounds    
    outcrop=""
    if cropBounds is not None:
        if cropBounds[0]>data.x.min().values or cropBounds[1]>data.y.min().values or cropBounds[2]<data.x.max().values or cropBounds[3]<data.y.max().values:
            return cube
#             bnd=[float(data.x.min().values),float(data.y.min().values),float(data.x.max().values),float(data.y.max().values)]
#             outcrop=".outside_"+'-'.join([str(i) for i in cropBounds])+'_vs_'+'-'.join([str(i) for i in bnd])+'.'

    # remove >5% nodata
    clearthreshold=int((1.-maxnodata)*float(data.shape[-1])*float(data.shape[-2]))
    counts=list(zip(
        data.t.values,
        data.count(dim=['x','y']).values[:,0]
    ))
    keepdates=[i[0] for i in counts if i[1]>clearthreshold]
    data=data.loc[ dict(t=keepdates) ]
    
    if data.t.shape[0]>0:

        # format name    
        centerx=int(0.5*(data.x[0]+data.x[-1]))
        centery=int(0.5*(data.y[0]+data.y[-1]))
        outpath=dump_location+'/'+str(year)+'/'+tileID+'/sample_{}_{}_{}_{}{}'.format(tileID,str(year),str(centerx),str(centery),outcrop)

        # create parent dir structure
        pathlib.Path(dump_location+'/'+str(year)).mkdir(exist_ok=True)
        pathlib.Path(dump_location+'/'+str(year)+'/'+tileID).mkdir(exist_ok=True)
    
        # flip around so increasing coordinate labels along x & y
        if (data.x[0]>data.x[-1]):
            data=data.reindex(x=list(reversed(data.x)))
        if (data.y[0]>data.y[-1]):
            data=data.reindex(y=list(reversed(data.y)))
    
        # convert to byte
        data=(data+0.08)*250.
        data=data.clip(min=0., max=250.).fillna(255.).astype(numpy.uint8)
        
        # reduce coordinates as well
        data['x']=data.x.astype(numpy.int32)
        data['y']=data.y.astype(numpy.int32)
        
        # save
        #datacube_to_file(DataCube(data), outpath+'.json', fmt='json')
        XarrayDataCube(data).save_to_file(outpath+'.nc',   fmt='netcdf')
        #datacube_to_file(data,outpath+'.nc',   fmt='netcdf')
    
    return cube

