# -*- coding: utf-8 -*-
# Uncomment the import only for coding support
from openeo_udf.api.datacube import DataCube
from typing import Dict


def apply_datacube(cube: DataCube, context: Dict) -> DataCube:

#     import uuid
#     import numpy
#     import itertools

#     import json
#     from uuid import uuid4
#     with open('/data/users/Public/banyait/reduce_'+str(uuid4().hex)+'.json','w') as f:
#         json.dump(context, f)


    # set how much images to select in the order of highest number of clear pixels
    maxlayers=15
    if context is not None:
        maxlayers=int(context.get('maxlayers',maxlayers))

    # get the underlying xarray
    inputarray=cube.get_array()
    
    # prepare uniform coordinates
#    trange=numpy.arange(numpy.datetime64(str(inputarray.t.dt.year.values[0])+'-01-01'),numpy.datetime64(str(inputarray.t.dt.year.values[0])+'-01-31'))
    

    # selecting clearest images over whole range
    counts=list(sorted(zip(
        inputarray.t.values,
        inputarray.count(dim=['x','y']).values[:,0]
    ), key=lambda i: i[1], reverse=True))
    keepdates=[i[0] for i in counts[:maxlayers]]

#     # split into maxlayers portion and select clearest images
#     dates_counts=list(sorted(zip(
#         inputarray.t.values,
#         inputarray.count(dim=['x','y']).values[:,0]
#     ), key=lambda i: i[0]))
#     splits=numpy.array_split(dates_counts,maxlayers)
#     keepdates=[ sorted(i, key=lambda k: k[1], reverse=True)[0][0] for i in splits ]

    # return the selected ones 
    resultarray=inputarray.loc[ dict(t=keepdates) ]
    resultarray=resultarray.sortby(resultarray.t,ascending=True)
    
    
    
    return DataCube(resultarray)

