# -*- coding: utf-8 -*-
# Uncomment the import only for coding support
from openeo_udf.api.udf_data import UdfData


def udf(data: UdfData):

    area_threshold=0.25*10000
    if data.user_context is not None:
        area_threshold=data.user_context.get('area_threshold',area_threshold)
    
    # build the polygon
    for ifeat in data.get_feature_collection_list():
        df=ifeat.get_data()
        df=df[df.area>=area_threshold]
        ifeat.set_data(df)     

    return data