"""
Function that will calc how much padding should be done to an ndarray to the proper dimensions for modelling
"""
from loguru import logger
import datetime
import pandas as pd

def calc_padding(ds, start_month, end_month, n_tsteps, year,
                 nsteps_month=3):
    # check if n_tsteps aligns with input data
    if ds.t.shape[0] < n_tsteps:
        logger.warning(f'Less than requested amount of {n_tsteps} steps',
                       f'actual {ds.t.shape[0]} steps')
        logger.warning(f'Adding {n_tsteps - ds.t.shape[0]} empty tsteps')
        
        # Infer exact processing dates from months and year
        startdate, enddate = (datetime.datetime(year, start_month, 1).date(),
                              datetime.datetime(year, end_month, 31).date())
      
        # calculate the amount of months missing at the start
        n_days_missing_before = pd.to_datetime(ds.t.isel(t=0).values)- pd.to_datetime(startdate)
        n_days_missing_before = n_days_missing_before.days
        if nsteps_month == 3:
            n_ts_missing_before = round(n_days_missing_before/10)
            
        # calculate the amount of months missing at the end
        n_days_missing_after = pd.to_datetime(enddate) - pd.to_datetime(ds.t.isel(t=-1).values)
        n_days_missing_after = n_days_missing_after.days
        if nsteps_month == 3:
            n_ts_missing_after = round(n_days_missing_after/10) - 1
        return n_ts_missing_before, n_ts_missing_after     
    else:
        return 0, 0

    