from loguru import logger
import shutil
from pathlib import Path
from openeo.udf.debug import inspect



def download_and_unpack(modeldir: str, modeltag: str, cache_dir: str, format='gztar'):
    import urllib

    modelfile = modeldir + '/' + modeltag
    extract_dir = cache_dir

    logger.info(f'Downloading modelfile: {modelfile}')
    try:
        modelfile, _ = urllib.request.urlretrieve(modelfile)
    except Exception:
        logger.error(f'Failed to download model from: {modelfile}.')
        raise

    try:
        shutil.unpack_archive(modelfile,
                              extract_dir=extract_dir,
                              format=format)
    except Exception as e:
        inspect(
            message=f"Failed to extract model archive. Make sure it is a gztar compressed file. Exception: {e}",
            code="load_delineation_model",
            level="error"
        )
        raise

    return extract_dir, modeltag