"""Functions that will convert the openeo output into a raster with unique field ids"""


# import needed packages 
import rasterio
from pathlib import Path
import numpy as np
import os
from fielddelineation.utils.prediction import stitch_pred


def postproc_del(dir_semantic, PRED_CONTEXT):
    """
    Function that will apply a segmentation on 
    the semanting field delineation output and 
    write the output into a raster.
    The context input defines which kind of model 
    was used to create the semantic output.
    """
    outfolder_delineation_rst = Path(dir_semantic).parent
    transform_raster = rasterio.open(dir_semantic, 'r').transform
    crs_from = rasterio.open(dir_semantic, 'r').crs
    outname_rst = Path(dir_semantic).stem + '_postproc.tif'
    preds = rasterio.open(dir_semantic, 'r').read(1)
    xdim, ydim = preds.shape[0], preds.shape[1]
    # It might happen that the stiching process (felzenswalb) 
    # segmentation is too heavy to process at once!!!
    # solution should be found for this
  
    preds_stitched = stitch_pred(PRED_CONTEXT, 
                                 preds)
    preds_stitched = preds_stitched.reshape(preds.shape)

    # check in which datatype it should be written
    if np.nanmax(preds_stitched) > 65535:
        dtype = 'uint32'
    else:
        dtype = 'uint16'

    with rasterio.open(os.path.join(outfolder_delineation_rst,
                                    outname_rst), 'w',
                       driver='GTiff', height=xdim,
                       width=ydim, count=1,
                       dtype=dtype, crs=crs_from, nodata=0,
                       transform=transform_raster) as dst_stitched:

        dst_stitched.write(preds_stitched, 1)
        dst_stitched.close()
    