from fielddelineation.openeo.udf_delineation import load_delineation_udf
from fielddelineation.openeo.preprocessing import delineation_preprocessed_inputs
import datetime


def delineation_map(extent, start_month, end_month, year,
                    connection, collections_options, processing_options):

    # Get processing dates
    start_date, end_date = (datetime.datetime(year, start_month, 1).date(),
                            datetime.datetime(year, end_month, 31).date())

    inputs = delineation_preprocessed_inputs(
        connection,
        extent,
        start_date,
        end_date,
        # will be done in the UDF with satio
        preprocess=processing_options.get('temp_aggr'),
        **collections_options, **processing_options)
    if processing_options['run_local']:
        return inputs

    context = {
        'start_month': start_month,
        'end_month': end_month,
        'year': year
    }
    context = {**processing_options, **context}

    delineation_udf = load_delineation_udf()

    clf_results = inputs.apply_neighborhood(
        lambda data: data.run_udf(
            udf=delineation_udf, runtime='Python', context=context),
        size=[
            {'dimension': 'x', 'value': processing_options.get(
                'sample_size'), 'unit': 'px'},
            {'dimension': 'y', 'value': processing_options.get(
                'sample_size'), 'unit': 'px'}
        ],
        overlap=[]
    ).rename_labels("bands", ["parcel_ids"])

    return clf_results
