"""Project wide utilities."""

from time import time


class MyTimer:
    """Custom timer functionality."""

    def __init__(self, tag: str) -> None:
        """Initialise the timer."""
        self.tag = tag
        self.time = {}

    def __enter__(self):
        """Start timing on entering."""
        self.time[self.tag] = time()

    def __exit__(self, *args):
        """Print out the time on exiting."""
        print(f"{self.tag} took {time() - self.time[self.tag]:.5f} seconds")


def my_timer(tag: str):
    """Time everything enclosed in a 'with' statement."""
    return MyTimer(tag=tag)


if __name__ == "__main__":
    from time import sleep

    with my_timer("test"):
        # Running code
        sleep(1)
    # Prints: test took 1.0039961338043213 seconds
