"""Base trainer."""

from __future__ import annotations

from vito_cropsar.models.base_config import TrainerBaseConfig
from vito_cropsar.models.base_trainer import TrainerBase
from vito_cropsar.models.naive.main import InpaintingModel


class Trainer(TrainerBase):
    """Base trainer class."""

    def __init__(
        self,
        model: InpaintingModel,
        cfg: TrainerBaseConfig,
    ) -> None:
        """
        Initialise the trainer.

        Parameters
        ----------
        model : InpaintingBase
            Model to train
        cfg : TrainerConfig
            Trainer configuration
        """
        super().__init__(
            model=model,
            cfg=cfg,
        )

    def train(self) -> None:
        """
        Train the InpaintingModel.

        Note: No training necessary for the naive model
        """
        self._model.save()
