"""Custom CNN-embedded Transformer implementation."""

from vito_cropsar.models.CnnTransformer.config import (
    ModelConfig as ConfigCnnTransformer,
)
from vito_cropsar.models.CnnTransformer.config import (
    MultiTrainerConfig as ConfigTrainerCnnTransformer,
)
from vito_cropsar.models.CnnTransformer.main import (
    InpaintingModel as InpaintingCnnTransformer,
)
from vito_cropsar.models.CnnTransformer.trainer import (
    MultiTrainer as TrainerCnnTransformer,
)

configuration_cnn_transformer = {
    "config_model": ConfigCnnTransformer,
    "config_trainer": ConfigTrainerCnnTransformer,
    "model": InpaintingCnnTransformer,
    "trainer": TrainerCnnTransformer,
}

__all__ = [
    "configuration_cnn_transformer",
    "ConfigCnnTransformer",
    "ConfigTrainerCnnTransformer",
    "InpaintingCnnTransformer",
    "TrainerCnnTransformer",
]
