"""Predictive models."""

from vito_cropsar.models.base_config import (
    AugmentationConfig,
    LossConfig,
    ModelBaseConfig,
    TrainerBaseConfig,
)
from vito_cropsar.models.base_model import InpaintingBase
from vito_cropsar.models.base_trainer import TrainerBase
from vito_cropsar.models.CnnTransformer import (
    ConfigCnnTransformer,
    ConfigTrainerCnnTransformer,
    InpaintingCnnTransformer,
    TrainerCnnTransformer,
    configuration_cnn_transformer,
)
from vito_cropsar.models.naive import InpaintingModel as InpaintingNaive
from vito_cropsar.models.naive import Trainer as TrainerNaive
from vito_cropsar.models.ResUNet3d import (
    ConfigResUNet3d,
    ConfigTrainerResUNet3d,
    InpaintingResUNet3d,
    TrainerResUNet3d,
    configuration_resunet3d,
)

__all__ = [
    "LossConfig",
    "AugmentationConfig",
    "ModelBaseConfig",
    "TrainerBaseConfig",
    "InpaintingBase",
    "TrainerBase",
    "InpaintingNaive",
    "TrainerNaive",
    "configuration_resunet3d",
    "InpaintingResUNet3d",
    "TrainerResUNet3d",
    "ConfigResUNet3d",
    "ConfigTrainerResUNet3d",
    "configuration_cnn_transformer",
    "InpaintingCnnTransformer",
    "TrainerCnnTransformer",
    "ConfigCnnTransformer",
    "ConfigTrainerCnnTransformer",
]
