import os


def get_spark_context(name="CROPCLASS", localspark=False,
                      pythonpath='/data/users/Public/kristofvt/'
                      'python/worldcereal/bin/python'):

    import pyspark.serializers
    import cloudpickle
    import pyspark
    from pyspark.sql import SparkSession

    pyspark.serializers.cloudpickle = cloudpickle

    if not localspark:

        spark = SparkSession.builder \
            .appName(name) \
            .getOrCreate()
        sc = spark.sparkContext
    else:
        os.environ['PYSPARK_PYTHON'] = pythonpath
        spark = SparkSession.builder \
            .appName(name) \
            .master('local[1]') \
            .config('spark.driver.host', '127.0.0.1') \
            .config('spark.executor.memory', '2G') \
            .config('spark.driver.memory', '2G') \
            .getOrCreate()
        sc = spark.sparkContext

    # Set log level
    sc.setLogLevel("WARN")

    return sc
